export { SVG } from './svg/index.cjs';
export { parseSVG } from './svg/parse.cjs';
export { parseSVGStyle } from './svg/parse-style.cjs';
export { analyseSVGStructure } from './svg/analyse.cjs';
export { cleanupSVG } from './svg/cleanup.cjs';
export { removeBadAttributes } from './svg/cleanup/attribs.cjs';
export { checkBadTags } from './svg/cleanup/bad-tags.cjs';
export { cleanupRootStyle } from './svg/cleanup/root-style.cjs';
export { cleanupInlineStyle } from './svg/cleanup/inline-style.cjs';
export { cleanupSVGRoot } from './svg/cleanup/root-svg.cjs';
export { convertStyleToAttrs } from './svg/cleanup/svgo-style.cjs';
export { IconSet, blankIconSet } from './icon-set/index.cjs';
export { mergeIconSets } from './icon-set/merge.cjs';
export { addTagsToIconSet } from './icon-set/tags.cjs';
export { importFromFigma } from './import/figma/index.cjs';
export { importDirectory, importDirectorySync } from './import/directory.cjs';
export { downloadGitRepo } from './download/git/index.cjs';
export { getGitRepoHash } from './download/git/hash.cjs';
export { getGitRepoBranch } from './download/git/branch.cjs';
export { resetGitRepoContents } from './download/git/reset.cjs';
export { downloadGitHubRepo } from './download/github/index.cjs';
export { getGitHubRepoHash } from './download/github/hash.cjs';
export { downloadGitLabRepo } from './download/gitlab/index.cjs';
export { getGitLabRepoHash } from './download/gitlab/hash.cjs';
export { downloadNPMPackage } from './download/npm/index.cjs';
export { getNPMVersion, getPackageVersion } from './download/npm/version.cjs';
export { downloadPackage } from './download/index.cjs';
export { downloadFile } from './download/api/download.cjs';
export { isEmptyColor, parseColors } from './colors/parse.cjs';
export { validateColors } from './colors/validate.cjs';
export { detectIconSetPalette } from './colors/detect.cjs';
export { runSVGO } from './optimise/svgo.cjs';
export { removeFigmaClipPathFromSVG } from './optimise/figma.cjs';
export { deOptimisePaths } from './optimise/flags.cjs';
export { resetSVGOrigin } from './optimise/origin.cjs';
export { convertSVGToMask } from './optimise/mask.cjs';
export { scaleSVG } from './optimise/scale.cjs';
export { cleanupGlobalStyle } from './optimise/global-style.cjs';
export { exportToDirectory } from './export/directory.cjs';
export { exportJSONPackage } from './export/json-package.cjs';
export { exportIconPackage } from './export/icon-package.cjs';
export { writeJSONFile } from './misc/write-json.cjs';
export { prepareDirectoryForExport } from './export/helpers/prepare.cjs';
export { scanDirectory, scanDirectorySync } from './misc/scan.cjs';
export { compareDirectories } from './misc/compare-dirs.cjs';
export { unzip } from './download/helpers/unzip.cjs';
export { untar } from './download/helpers/untar.cjs';
export { execAsync } from './misc/exec.cjs';
export { cleanupIconKeyword } from './misc/keyword.cjs';
export { bumpVersion } from './misc/bump-version.cjs';
export { axiosConfig, fetchCallbacks } from './download/api/config.cjs';
export { sendAPIQuery } from './download/api/index.cjs';
export { defaultQueueParams, runConcurrentQueries } from './download/api/queue.cjs';
import 'cheerio';
import '@iconify/types';
import '@iconify/utils/lib/customisations/defaults';
import './misc/cheerio.cjs';
import 'domhandler';
import './css/parser/types.cjs';
import './svg/analyse/types.cjs';
import './icon-set/types.cjs';
import '@iconify/utils/lib/icon-set/tree';
import './download/types/modified.cjs';
import './import/figma/types/options.cjs';
import './import/figma/types/nodes.cjs';
import './import/figma/types/api.cjs';
import './import/figma/types/result.cjs';
import './download/types/sources.cjs';
import './download/github/types.cjs';
import './download/gitlab/types.cjs';
import './download/npm/types.cjs';
import './download/api/types.cjs';
import '@iconify/utils/lib/colors/types';
import './colors/attribs.cjs';
import 'svgo';
import './export/helpers/custom-files.cjs';
import 'fs';
import 'child_process';
import 'axios';
