function initDataTable(tableId, ajaxUrl, columns, options = {}) {
  const defaultOptions = {
    processing: true,
    serverSide: true,
    ajax: ajaxUrl,
    columns: columns,
    language: {
      processing: '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div>'
    },
    pageLength: 10,
    lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
    order: [[0, 'desc']]
  };

  // Merge custom options with defaults
  const finalOptions = { ...defaultOptions, ...options };

  return $(tableId).DataTable(finalOptions);
}