@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Account Category')

@php
$m = 'App\\Models\\AccountCategory';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('account-category.index'), 'label' => 'Account Category'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('account-category.show', ['account_category' => $model->id]),
            'label' => $model->name,
        ];
        $breadcrumbs[] = [
            'url' => route('account-category.edit', ['account_category' => $model->id]),
            'label' => 'Update Account Category',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('account-category.create'),
            'label' => 'Create Account Category',
        ];
    }

@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Account Category</h5>
                            <p class="text-muted mb-0 small">{{ $model->id ? 'Update account category information' : 'Fill in the details below to create a new account category' }}</p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
            <form id="account-category-form" method="POST" action="{{ $model->id ? route('account-category.update', ['account_category' => $model->id]) : route('account-category.store') }}">
                @csrf
                @if ($model->id)
                    @method('PUT')
                @endif

                <div class="row g-3">
                            <!-- Category -->
                            <div class="col-md-12">
                                <label for="name" class="form-label">
                                    {{ $labels['name'] ?? 'Category' }} <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    id="name" name="name" value="{{ old('name', $model->name) }}" required
                                    placeholder="Enter category" autofocus>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('account-category.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="account-category-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Account Category
        </button>
    </div>
@endsection
