@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Account Type')

@php
$m = 'App\\Models\\AccountType';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('account-type.index'), 'label' => 'Account Type'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('account-type.show', ['account_type' => $model->id]),
            'label' => $model->name,
        ];
        $breadcrumbs[] = [
            'url' => route('account-type.edit', ['account_type' => $model->id]),
            'label' => 'Update Account Type',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('account-type.create'),
            'label' => 'Create Account Type',
        ];
    }

@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Account Type</h5>
                            <p class="text-muted mb-0 small">
                                {{ $model->id ? 'Update account type information' : 'Fill in the details below to create a new account type' }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
                    <form id="account-type-form" method="POST"
                        action="{{ $model->id ? route('account-type.update', ['account_type' => $model->id]) : route('account-type.store') }}">
                        @csrf
                        @if ($model->id)
                            @method('PUT')
                        @endif

                        <div class="row g-3">
                            <!-- Type -->
                            <div class="col-md-12">
                                <label for="name" class="form-label">
                                    {{ $labels['name'] ?? 'Type' }} <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    id="name" name="name" value="{{ old('name', $model->name) }}" required
                                    placeholder="Enter type" autofocus>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Form Actions - Sticky to bottom -->
        <div class="form-actions-sticky">
            <a href="{{ route('account-type.index') }}" class="btn btn-sm btn-label-secondary">
                Cancel
            </a>
            <button type="submit" form="account-type-form" class="btn btn-sm btn-primary">
                {{ $model->id ? 'Update' : 'Create' }} Account Type
            </button>
        </div>
    @endsection
