@extends('layouts.layoutMaster')

@section('title', 'Account Type Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('account-type.index'), 'label' => 'Account Type'],
        ['url' => route('account-type.show', ['account_type' => $model->id]), 'label' => $model->name],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Account Type Details</h5>
            @can('account-type.update')
                <a href="{{ route('account-type.edit', ['account_type' => $model->id]) }}" class="btn btn-sm btn-primary">
                    Edit
                </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Type Information -->
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Type</td>
                                    <td>{{ $model->name }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
