@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Account')

@section('vendor-style')
    @vite('resources/assets/vendor/libs/select2/select2.scss')
@endsection

@section('vendor-script')
    @vite('resources/assets/vendor/libs/select2/select2.js')
@endsection

@section('page-script')
    @vite('resources/assets/js/forms-selects.js')
@endsection

@php
$m = 'App\\Models\\Account';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
['url' => route('dashboard'), 'label' => 'Dashboard'],
['url' => route('account.index'), 'label' => 'Account'],
];

if ($model->id) {
$breadcrumbs[] = [
'url' => route('account.show', ['account' => $model->id]),
'label' => $model->name,
];
$breadcrumbs[] = [
'url' => route('account.edit', ['account' => $model->id]),
'label' => 'Update Account',
];
} else {
$breadcrumbs[] = [
'url' => route('account.create'),
'label' => 'Create Account',
];
}

@endphp

@section('content')
<div class="row form-row-with-sticky-actions">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white border-bottom">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Account</h5>
                        <p class="text-muted mb-0 small">{{ $model->id ? 'Update account information' : 'Fill in the details below to create a new account' }}</p>
                    </div>
                </div>
            </div>
            <div class="card-body pt-4">
                <form id="account-form" method="POST" action="{{ $model->id ? route('account.update', ['account' => $model->id]) : route('account.store') }}">
                    @csrf
                    @if ($model->id)
                    @method('PUT')
                    @endif

                    <div class="row g-3">
                        <!-- {{ $labels['code'] ?? 'Account Code' }} -->
                        <div class="col-md-6">
                            <label for="code" class="form-label">
                                {{ $labels['code'] ?? 'Account Code' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('code') is-invalid @enderror"
                                id="code" name="code" value="{{ old('code', $model->code) }}" required
                                placeholder="Enter account code" autofocus>
                            @error('code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- {{ $labels['name'] ?? 'Account Name' }} -->
                        <div class="col-md-6">
                            <label for="name" class="form-label">
                                {{ $labels['name'] ?? 'Account Name' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                id="name" name="name" value="{{ old('name', $model->name) }}" required
                                placeholder="Enter account name">
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Category -->
                        <div class="col-md-6">
                            <label for="id_category" class="form-label">
                                {{ $labels['id_category'] ?? 'Category' }} <span class="text-danger">*</span>
                            </label>
                            <select class="form-select select2 @error('id_category') is-invalid @enderror" id="id_category" name="id_category" required>
                                <option value="">-- Select Category --</option>
                                @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ old('id_category', $model->id_category) == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                                @endforeach
                            </select>
                            @error('id_category')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Type -->
                        <div class="col-md-6">
                            <label for="id_type" class="form-label">
                                {{ $labels['id_type'] ?? 'Type' }} <span class="text-danger">*</span>
                            </label>
                            <select class="form-select select2 @error('id_type') is-invalid @enderror" id="id_type" name="id_type" required>
                                <option value="">-- Select Type --</option>
                                @foreach($types as $type)
                                <option value="{{ $type->id }}" {{ old('id_type', $model->id_type) == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }}
                                </option>
                                @endforeach
                            </select>
                            @error('id_type')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Nature -->
                        <div class="col-md-12">
                            <label for="nature" class="form-label">
                                {{ $labels['nature'] ?? 'Nature' }} <span class="text-danger">*</span>
                            </label>
                            <select class="form-select @error('nature') is-invalid @enderror" id="nature" name="nature" required>
                                <option value="">-- Select Nature --</option>
                                <option value="Debit" {{ old('nature', $model->nature) == 'Debit' ? 'selected' : '' }}>Debit</option>
                                <option value="Credit" {{ old('nature', $model->nature) == 'Credit' ? 'selected' : '' }}>Credit</option>
                            </select>
                            @error('nature')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('account.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="account-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Account
        </button>
    </div>
    @endsection