@props([
    'id' => 'dataTable',
    'url' => '',
    'columns' => [],
    'filters' => [],
    'order' => [[0, 'asc']],
    'pageLength' => 10,
    'searchable' => true,
    'exportable' => false,
    'create_url' => '',
    'title' => '',
    'resource' => '',
])

@php
    // Determine if user can create based on resource permission
    $canCreate = true;
    if (!empty($create_url) && !empty($resource)) {
        $canCreate = auth()->user()->can($resource . '.store');
    }
@endphp

<style>
    table th {
        color: #6c718a !important;
        font-weight: 600;
        background-color: var(--bs-menu-sub-active-bg) !important;
        padding-left: 0;
        padding-right: 0;
        font-size: 11px !important;
    }

    table td {
        font-size: 13px !important;
    }

    table.dataTable th.text-end div.dt-column-header {
        flex-direction: row !important;
        justify-content: space-between !important;
        gap: 24px;
    }

    table.dataTable th.text-start div.dt-column-header {
        flex-direction: row-reverse !important;
        justify-content: space-between !important
    }

    table td {
        color: #000000 !important;
    }

    .dt-layout-start {
        padding-left: 0px !important;
    }

    .order-select-active {
        border-color: var(--bs-primary) !important;
        color: var(--bs-primary) !important;
        background-image: url('data:image/svg+xml,%3csvg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 22" fill="none"%3e%3cpath d="M10.9999 12.0743L15.5374 7.53676L16.8336 8.83292L10.9999 14.6666L5.16626 8.83292L6.46243 7.53676L10.9999 12.0743Z" fill="%232092EC" fill-opacity="0.9"/%3e%3c/svg%3e') !important;
    }

    td.action {
        display: flex;
        justify-content: flex-end;
    }
</style>

<div class="datatable-wrapper">
    {{-- DataTable --}}
    <table id="{{ $id }}" class="table" style="width:100%">
        <thead>
            <tr>
                @foreach ($columns as $column)
                    <th class="{{ $column['className'] ?? '' }}">{{ $column['title'] }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof $ === 'undefined' || typeof $.fn.DataTable === 'undefined') {
                console.error('jQuery or DataTables not loaded');
                return;
            }

            $(document).ready(function() {
                // Function to update filter button style
                function updateFilterButtonStyle() {
                    const hasActiveFilters = $('#{{ $id }}-filters .filter-input').toArray().some(
                        input => {
                            return $(input).val() && $(input).val() !== '';
                        });

                    const filterBtn = $('#{{ $id }}-filter-toggle-btn');
                    if (hasActiveFilters) {
                        filterBtn.addClass('btn-outline-primary');
                        filterBtn.css({
                            'border': '',
                            'color': ''
                        });
                    } else {
                        filterBtn.removeClass('btn-outline-primary');
                        filterBtn.css({
                            'border': 'calc(var(--bs-border-width) * 1.2) solid color-mix(in sRGB, var(--bs-base-color) 22%, var(--bs-paper-bg))',
                            'color': 'calc(var(--bs-border-width) * 1.2) solid color-mix(in sRGB, var(--bs-base-color) 22%, var(--bs-paper-bg))'
                        });
                    }
                }

                // Function to update order dropdown styles
                function updateOrderDropdownStyle() {
                    const orderBy = $('#{{ $id }}-order-by');
                    const orderMode = $('#{{ $id }}-order-mode');

                    // Only turn blue when Order By is selected
                    if (orderBy.val() !== '') {
                        orderBy.addClass('order-select-active');
                        orderMode.addClass('order-select-active');
                    } else {
                        orderBy.removeClass('order-select-active');
                        orderMode.removeClass('order-select-active');
                    }
                }

                // Initialize DataTable
                const table = $('#{{ $id }}').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '{{ $url }}',
                        data: function(d) {
                            // Add filter values to the request
                            @if (count($filters) > 0)
                                d.filters = {};
                                @foreach ($filters as $filter)
                                    const filterValue_{{ $filter['name'] }} = $(
                                        '#filter-{{ $filter['name'] }}').val();
                                    if (filterValue_{{ $filter['name'] }} &&
                                        filterValue_{{ $filter['name'] }} !== '' &&
                                        filterValue_{{ $filter['name'] }} !== null) {
                                        d.filters.{{ $filter['name'] }} =
                                            filterValue_{{ $filter['name'] }};
                                    }
                                @endforeach

                                // If no filters are active, don't send the filters object
                                if (Object.keys(d.filters).length === 0) {
                                    delete d.filters;
                                }
                            @endif
                        }
                    },
                    columns: @json($columns),
                    order: @json($order),
                    pageLength: {{ $pageLength }},
                    searching: {{ $searchable ? 'true' : 'false' }},
                    ordering: true,
                    columnDefs: [{
                        orderable: false,
                        targets: '_all'
                    }],
                    layout: {
                        topStart: {
                            rowClass: 'row m-3 my-0 justify-content-between',
                            features: [{
                                pageLength: {
                                    menu: [10, 25, 50, 100],
                                    text: '_MENU_'
                                },
                                div: {
                                    id: "top-layout"
                                }
                            }]
                        },
                        topEnd: function() {
                            return `
                                <div class="d-flex gap-2">
                                    <button id="{{ $id }}-filter-toggle-btn" class="btn     btn-sm d-flex gap-2 align-items-center" style="border: calc(var(--bs-border-width) * 1.2) solid color-mix(in sRGB, var(--bs-base-color) 22%, var(--bs-paper-bg)); color: calc(var(--bs-border-width) * 1.2) solid color-mix(in sRGB, var(--bs-base-color) 22%, var(--bs-paper-bg));">
                                        Filter
                                    </button>
                                    @if (!empty($create_url) && $canCreate)
                                        <div class="d-flex gap-3">
                                            <button data-action="create" data-url="{{ $create_url }}" class="btn btn-sm btn-primary d-flex align-items-center gap-2 btn-action">Create {{ $title }}</button>
                                        </div>
                                    @endif
                                </div>
                            `
                        },
                        bottomStart: {
                            rowClass: 'row mx-3 justify-content-between',
                            features: ['info', ]
                        },
                        bottomEnd: 'paging'
                    },
                    language: {
                        paginate: {
                            next: '<i class="icon-base ti tabler-chevron-right scaleX-n1-rtl icon-18px"></i>',
                            previous: '<i class="icon-base ti tabler-chevron-left scaleX-n1-rtl icon-18px"></i>',
                            first: '<i class="icon-base ti tabler-chevrons-left scaleX-n1-rtl icon-18px"></i>',
                            last: '<i class="icon-base ti tabler-chevrons-right scaleX-n1-rtl icon-18px"></i>'
                        }
                    },
                });

                table.ready(() => {
                    const parent = $("#top-layout").parent().parent();

                    const filterHtml = `
                        @if (count($filters) > 0)
                            <div style="padding: 1.5rem 0; border-bottom: 1px solid #e0e0e0;">
                                <form id="{{ $id }}-filters" class="row g-3">
                                    @foreach ($filters as $filter)
                                        <div class="col-md-{{ $filter['col'] ?? 3 }}">
                                            @if ($filter['type'] === 'text')
                                                <input type="text" class="form-control filter-input" id="filter-{{ $filter['name'] }}"
                                                    name="{{ $filter['name'] }}" placeholder="{{ $filter['label'] }}">
                                            @elseif ($filter['type'] === 'select')
                                                <select class="form-select filter-input" id="filter-{{ $filter['name'] }}"
                                                    name="{{ $filter['name'] }}">
                                                    <option value="">{{ $filter['label'] }}</option>
                                                    @foreach ($filter['options'] as $value => $label)
                                                        <option value="{{ $value }}">{{ $label }}</option>
                                                    @endforeach
                                                </select>
                                            @elseif ($filter['type'] === 'date')
                                                <input type="date" class="form-control filter-input"
                                                    id="filter-{{ $filter['name'] }}" name="{{ $filter['name'] }}"
                                                    placeholder="{{ $filter['label'] }}">
                                            @elseif ($filter['type'] === 'daterange')
                                                <input type="text" class="form-control filter-input daterange"
                                                    id="filter-{{ $filter['name'] }}" name="{{ $filter['name'] }}"
                                                    placeholder="{{ $filter['label'] }}">
                                            @elseif ($filter['type'] === 'number')
                                                <input type="number" class="form-control filter-input"
                                                    id="filter-{{ $filter['name'] }}" name="{{ $filter['name'] }}"
                                                    placeholder="{{ $filter['label'] }}" min="{{ $filter['min'] ?? '' }}"
                                                    max="{{ $filter['max'] ?? '' }}">
                                            @endif
                                        </div>
                                    @endforeach

                                    <div class="col-12 d-flex justify-content-end gap-2">
                                        <button type="button" class="btn btn-danger btn-sm" id="{{ $id }}-reset-btn">
                                            Reset Filter
                                        </button>
                                        <button type="button" class="btn btn-primary btn-sm" id="{{ $id }}-apply-filter-btn">
                                            Apply Filter
                                        </button>
                                    </div>
                                </form>
                            </div>
                        @endif
                    `;

                    const filterContainer = $(
                        `<div class="row m-3 my-0" id="{{ $id }}-filter-container" style="display: none;">${filterHtml}</div>`
                    );

                    $(parent).after(filterContainer);

                    // Toggle filter visibility when top filter button is clicked
                    $('#{{ $id }}-filter-toggle-btn').on('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        filterContainer.slideToggle();
                    });

                    // Order by dropdown change
                    $('#{{ $id }}-order-by').on('change', function() {
                        const columnIndex = parseInt($(this).val());
                        let orderMode = $('#{{ $id }}-order-mode').val();

                        if (!isNaN(columnIndex)) {
                            // If order mode is not selected, set it to desc
                            if (!orderMode || orderMode === '') {
                                orderMode = 'desc';
                                $('#{{ $id }}-order-mode').val(orderMode);
                            }
                            table.order([columnIndex, orderMode]).draw();
                        }
                        updateOrderDropdownStyle();
                    });

                    // Order mode dropdown change
                    $('#{{ $id }}-order-mode').on('change', function() {
                        const columnIndex = parseInt($('#{{ $id }}-order-by')
                            .val());
                        const orderMode = $(this).val();

                        // Only apply order if order by is selected
                        if (!isNaN(columnIndex) && orderMode !== '') {
                            table.order([columnIndex, orderMode]).draw();
                        }
                        updateOrderDropdownStyle();
                    });
                });

                // Apply filter button
                $(document).on('click', '#{{ $id }}-apply-filter-btn', function() {
                    table.ajax.reload();
                    updateFilterButtonStyle();
                });

                // Reset filter button
                $(document).on('click', '#{{ $id }}-reset-btn', function() {
                    $('#{{ $id }}-filters')[0].reset();
                    $('.daterange').val('');
                    table.ajax.reload();
                    updateFilterButtonStyle();
                });

                // Apply filter on enter key
                $(document).on('keypress', '#{{ $id }}-filters .filter-input', function(e) {
                    if (e.which === 13) {
                        e.preventDefault();
                        $('#{{ $id }}-apply-filter-btn').click();
                    }
                });

                $(document).on("click", ".btn-action", function(e) {

                    e.preventDefault();

                    const id = $(this).data("id");
                    const url = $(this).data("url");
                    const action = $(this).data("action");

                    if (["view", "edit", "create"].includes(action)) {
                        window.location.href = url;
                    } else if (action === "delete") {
                        // Show confirmation dialog before deleting
                        if (confirm(
                                "Are you sure you want to delete this item? This action cannot be undone."
                            )) {
                            // Perform delete action
                            $.ajax({
                                url: url,
                                type: 'DELETE',
                                data: {
                                    _token: $('meta[name="csrf-token"]').attr('content')
                                },
                                success: function(response) {
                                    if (response.success) {
                                        // Show success toast notification
                                        if (typeof showSuccessNotification ===
                                            'function') {
                                            showSuccessNotification(response.message ||
                                                'Item deleted successfully');
                                        }
                                        // Reload the datatable
                                        table.ajax.reload();
                                    } else {
                                        // Show error toast notification
                                        if (typeof showErrorNotification ===
                                            'function') {
                                            showErrorNotification(response.message ||
                                                'Failed to delete item');
                                        }
                                    }
                                },
                                error: function(xhr) {
                                    // Show error toast notification
                                    const message = xhr.responseJSON?.message ||
                                        'An error occurred while deleting the item';
                                    if (typeof showErrorNotification === 'function') {
                                        showErrorNotification(message);
                                    } else {
                                        alert(message);
                                    }
                                }
                            });
                        }
                    }
                });
            });


        });
    </script>
@endpush
