@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Config')

@php
$m = 'App\\Models\\Config';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('config.index'), 'label' => 'Config'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('config.show', ['config' => $model->id]),
            'label' => $model->key,
        ];
        $breadcrumbs[] = [
            'url' => route('config.edit', ['config' => $model->id]),
            'label' => 'Update Config',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('config.create'),
            'label' => 'Create Config',
        ];
    }

@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Config</h5>
                            <p class="text-muted mb-0 small">
                                {{ $model->id ? 'Update config information' : 'Fill in the details below to create a new config' }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
                    <form id="config-form" method="POST"
                        action="{{ $model->id ? route('config.update', ['config' => $model->id]) : route('config.store') }}">
                        @csrf
                        @if ($model->id)
                            @method('PUT')
                        @endif

                        <div class="row g-3">
                            <!-- Key -->
                            <div class="col-md-12">
                                <label for="key" class="form-label">
                                    {{ $labels['key'] ?? 'Key' }} <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('key') is-invalid @enderror"
                                    id="key" name="key" value="{{ old('key', $model->key) }}"
                                    required autofocus placeholder="Enter config key (e.g., app_name, tax_rate)">
                                @error('key')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Value -->
                            <div class="col-md-12">
                                <label for="value" class="form-label">
                                    {{ $labels['value'] ?? 'Value' }}
                                </label>
                                <textarea class="form-control @error('value') is-invalid @enderror"
                                    id="value" name="value" rows="4"
                                    placeholder="Enter config value">{{ old('value', $model->value) }}</textarea>
                                @error('value')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('config.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="config-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Config
        </button>
    </div>
@endsection
