@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Customer')

@php
$m = 'App\\Models\\Customer';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
['url' => route('dashboard'), 'label' => 'Dashboard'],
['url' => route('customer.index'), 'label' => 'Customer'],
];

if ($model->id) {
$breadcrumbs[] = [
'url' => route('customer.show', ['customer' => $model->id]),
'label' => $model->full_name,
];
$breadcrumbs[] = [
'url' => route('customer.edit', ['customer' => $model->id]),
'label' => 'Update Customer',
];
} else {
$breadcrumbs[] = [
'url' => route('customer.create'),
'label' => 'Create Customer',
];
}

@endphp

@section('content')
<div class="row form-row-with-sticky-actions">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white border-bottom">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Customer</h5>
                        <p class="text-muted mb-0 small">
                            {{ $model->id ? 'Update customer information' : 'Fill in the details below to create a new customer' }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="card-body pt-4">
                <form id="customer-form" method="POST"
                    action="{{ $model->id ? route('customer.update', ['customer' => $model->id]) : route('customer.store') }}">
                    @csrf
                    @if ($model->id)
                    @method('PUT')
                    @endif

                    <div class="row g-3">
                        <!-- Full Name -->
                        <div class="col-md-6">
                            <label for="full_name" class="form-label">
                                {{ $labels['full_name'] ?? 'Full Name' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('full_name') is-invalid @enderror"
                                id="full_name" name="full_name" value="{{ old('full_name', $model->full_name) }}"
                                required autofocus placeholder="Enter customer full name">
                            @error('full_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Email -->
                        <div class="col-md-6">
                            <label for="email" class="form-label">
                                {{ $labels['email'] ?? 'Email' }}
                            </label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror"
                                id="email" name="email" value="{{ old('email', $model->email) }}"
                                placeholder="example@company.com">
                            @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Phone -->
                        <div class="col-md-6">
                            <label for="phone" class="form-label">
                                {{ $labels['phone'] ?? 'Phone' }} <span class="text-danger">*</span>
                            </label>
                            <input type="tel" class="form-control @error('phone') is-invalid @enderror"
                                id="phone" name="phone" value="{{ old('phone', $model->phone) }}" required
                                placeholder="08XX-XXXX-XXXX">
                            @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Address -->
                        <div class="col-md-6">
                            <label for="address" class="form-label">
                                {{ $labels['address'] ?? 'Address' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('address') is-invalid @enderror"
                                id="address" name="address" value="{{ old('address', $model->address) }}" required
                                placeholder="Street address, City, Province">
                            @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">PIC (Person in Charge)</h6>
                            </div>
                        </div>

                        <!-- PIC Name -->
                        <div class="col-md-6">
                            <label for="pic_name" class="form-label">
                                {{ $labels['pic_name'] ?? 'PIC Name' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('pic_name') is-invalid @enderror"
                                id="pic_name" name="pic_name" value="{{ old('pic_name', $model->pic_name) }}" required
                                placeholder="Enter PIC name">
                            @error('pic_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- PIC Phone -->
                        <div class="col-md-6">
                            <label for="pic_phone" class="form-label">
                                {{ $labels['pic_phone'] ?? 'PIC Phone' }} <span class="text-danger">*</span>
                            </label>
                            <input type="tel" class="form-control @error('pic_phone') is-invalid @enderror"
                                id="pic_phone" name="pic_phone" value="{{ old('pic_phone', $model->pic_phone) }}"
                                required placeholder="08XX-XXXX-XXXX">
                            @error('pic_phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Financial & Tax Information</h6>
                            </div>
                        </div>

                        <!-- Payment Terms -->
                        <div class="col-md-4">
                            <label for="term_of_payment" class="form-label">
                                {{ $labels['term_of_payment'] ?? 'Payment Terms (Days)' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('term_of_payment') is-invalid @enderror"
                                id="term_of_payment" name="term_of_payment"
                                value="{{ old('term_of_payment', $model->term_of_payment) }}" required
                                placeholder="e.g., 30" data-format="number" data-submit-raw="true">
                            @error('term_of_payment')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Credit Limit -->
                        <div class="col-md-4">
                            <label for="credit_limit" class="form-label">
                                {{ $labels['credit_limit'] ?? 'Credit Limit' }} <span class="text-danger">*</span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control @error('credit_limit') is-invalid @enderror"
                                    id="credit_limit" name="credit_limit"
                                    value="{{ old('credit_limit', Helper::formatNumber($model->credit_limit)) }}" placeholder="0" required
                                    data-format="number" data-submit-raw="true">
                                @error('credit_limit')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- NPWP Number -->
                        <div class="col-md-4">
                            <label for="npwp_no" class="form-label">{{ $labels['npwp_no'] ?? 'NPWP Number' }}</label>
                            <input type="text" class="form-control @error('npwp_no') is-invalid @enderror"
                                id="npwp_no" name="npwp_no" value="{{ old('npwp_no', $model->npwp_no) }}"
                                maxlength="16" placeholder="Enter NPWP number">
                            @error('npwp_no')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Tax Settings -->
                        <div class="col-12">
                            <label class="form-label d-block mb-2">
                                Tax Configuration
                            </label>
                            <div class="d-flex gap-3">
                                <div class="form-check">
                                    <input class="form-check-input @error('is_ppn') is-invalid @enderror"
                                        type="checkbox" id="is_ppn" name="is_ppn" value="1"
                                        {{ old('is_ppn', $model->is_ppn) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_ppn">
                                        {{ $labels['is_ppn'] ?? 'Include PPN (VAT)' }}
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input @error('is_pph') is-invalid @enderror"
                                        type="checkbox" id="is_pph" name="is_pph" value="1"
                                        {{ old('is_pph', $model->is_pph) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_pph">
                                        {{ $labels['is_pph'] ?? 'Include PPh (Income Tax)' }}
                                    </label>
                                </div>
                            </div>
                            @error('is_ppn')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                            @error('is_pph')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Form Actions - Sticky to bottom -->
<div class="form-actions-sticky">
    <a href="{{ route('customer.index') }}" class="btn btn-sm btn-label-secondary">
        Cancel
    </a>
    <button type="submit" form="customer-form" class="btn btn-sm btn-primary">
        {{ $model->id ? 'Update' : 'Create' }} Customer
    </button>
</div>
@endsection