@extends('layouts.layoutMaster')

@section('title', 'Customer Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('customer.index'), 'label' => 'Customer'],
        ['url' => route('customer.show', ['customer' => $model->id]), 'label' => $model->full_name],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Customer Details</h5>
            @can('customer.update')
                <a href="{{ route('customer.edit', ['customer' => $model->id]) }}" class="btn btn-sm btn-primary">
                    Edit
                </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Basic Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Basic Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Full Name</td>
                                    <td>{{ $model->full_name }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Email Address</td>
                                    <td>{{ $model->email ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Phone Number</td>
                                    <td>{{ $model->phone }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Address</td>
                                    <td>{{ $model->address }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- PIC (Person in Charge) -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">PIC (Person in Charge)</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">PIC Name</td>
                                    <td>{{ $model->pic_name }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">PIC Phone</td>
                                    <td>{{ $model->pic_phone }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Financial & Tax Information -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Financial & Tax Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Payment Terms (Days)</td>
                                    <td>{{ $model->term_of_payment }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Credit Limit</td>
                                    <td>{{ \App\Helpers\Helpers::formatCurrency($model->credit_limit ?: 0, 2) }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">NPWP Number</td>
                                    <td>{{ $model->npwp_no ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">PPN (VAT)</td>
                                    <td>
                                        <span class="badge badge-sm {{ $model->is_ppn ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $model->is_ppn ? 'Yes' : 'No' }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">PPh (Income Tax)</td>
                                    <td>
                                        <span class="badge badge-sm {{ $model->is_pph ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $model->is_pph ? 'Yes' : 'No' }}
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quotations -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="mb-0">Quotations</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered small">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 50px;">No</th>
                            <th>Code</th>
                            <th>Invoice Date</th>
                            <th>Sales Person</th>
                            <th class="text-end">Total</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($model->quotations as $index => $quotation)
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                <td>
                                    @can('quotation.show')
                                        <a href="{{ route('quotation.show', ['quotation' => $quotation->id]) }}">
                                            <strong>{{ $quotation->code }}</strong>
                                        </a>
                                    @else
                                        <strong>{{ $quotation->code }}</strong>
                                    @endcan
                                </td>
                                <td>{{ $quotation->invoice_date?->format('d/m/Y') ?? '-' }}</td>
                                <td>{{ $quotation->sales->name ?? '-' }}</td>
                                <td class="text-end">{{ \App\Helpers\Helpers::formatCurrency($quotation->grand_total ?: 0, 2) }}</td>
                                <td>
                                    <span class="badge badge-sm bg-{{ $quotation->getStatusColor() }}">
                                        {{ strtoupper($quotation->status) }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted">No quotations available</td>
                            </tr>
                        @endforelse
                    </tbody>
                    @if($model->quotations->count() > 0)
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="4" class="text-end"><strong>TOTAL</strong></td>
                                <td class="text-end"><strong>{{ \App\Helpers\Helpers::formatCurrency($model->quotations->sum('grand_total'), 2) }}</strong></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    @endif
                </table>
            </div>
        </div>
    </div>

    <!-- Sales Orders -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="mb-0">Sales Orders</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered small">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 50px;">No</th>
                            <th>Code</th>
                            <th>Quotation</th>
                            <th>Invoice Date</th>
                            <th>Sales Person</th>
                            <th class="text-end">Total</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($model->salesOrders as $index => $salesOrder)
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                <td>
                                    @can('sales-order.show')
                                        <a href="{{ route('sales-order.show', ['sales_order' => $salesOrder->id]) }}">
                                            <strong>{{ $salesOrder->code }}</strong>
                                        </a>
                                    @else
                                        <strong>{{ $salesOrder->code }}</strong>
                                    @endcan
                                </td>
                                <td>
                                    @if($salesOrder->parentTransaction)
                                        <a href="{{ route('quotation.show', ['quotation' => $salesOrder->parentTransaction->id]) }}">
                                            {{ $salesOrder->parentTransaction->code }}
                                        </a>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td>{{ $salesOrder->invoice_date?->format('d/m/Y') ?? '-' }}</td>
                                <td>{{ $salesOrder->sales->name ?? '-' }}</td>
                                <td class="text-end">{{ \App\Helpers\Helpers::formatCurrency($salesOrder->grand_total ?: 0, 2) }}</td>
                                <td>
                                    <span class="badge badge-sm bg-{{ $salesOrder->getStatusColor() }}">
                                        {{ strtoupper($salesOrder->status) }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted">No sales orders available</td>
                            </tr>
                        @endforelse
                    </tbody>
                    @if($model->salesOrders->count() > 0)
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="5" class="text-end"><strong>TOTAL</strong></td>
                                <td class="text-end"><strong>{{ \App\Helpers\Helpers::formatCurrency($model->salesOrders->sum('grand_total'), 2) }}</strong></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    @endif
                </table>
            </div>
        </div>
    </div>
@endsection
