@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Delivery Order')

@section('vendor-style')
    @vite('resources/assets/vendor/libs/select2/select2.scss')
@endsection

@section('vendor-script')
    @vite('resources/assets/vendor/libs/select2/select2.js')
@endsection

@php
    $m = 'App\\Models\\DeliveryOrder';
    $labels = Helper::getModelLabels($m);

    // Get labels for DeliverOrderDetail (for driver, truck, delivery_date fields)
    $detailLabels = Helper::getModelLabels('App\\Models\\DeliverOrderDetail');

    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('delivery-order.index'), 'label' => 'Delivery Order'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('delivery-order.show', ['delivery_order' => $model->id]),
            'label' => $model->code,
        ];
        $breadcrumbs[] = [
            'url' => route('delivery-order.edit', ['delivery_order' => $model->id]),
            'label' => 'Update Delivery Order',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('delivery-order.create', ['sales_order' => $salesOrder->id ?? 0]),
            'label' => 'Create Delivery Order',
        ];
    }
@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            @if (!$model->id && isset($salesOrder))
                <div class="alert alert-info d-flex align-items-center mb-3">
                    <i class="icon-base ti tabler-info-circle me-2"></i>
                    <div>
                        <strong>Creating Delivery Order from Sales Order:</strong> {{ $salesOrder->code }}
                    </div>
                </div>
            @endif

            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Delivery Order</h5>
                            <p class="text-muted mb-0 small">
                                {{ $model->id ? 'Update delivery order information' : 'Fill in the details below to create a new delivery order' }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
                    <form id="delivery-order-form" method="POST"
                        action="{{ $model->id ? route('delivery-order.update', $model->id) : route('delivery-order.store') }}">
                        @csrf
                        @if ($model->id)
                            @method('PUT')
                        @endif

                        <input type="hidden" name="id_transaction"
                            value="{{ $salesOrder->id ?? ($model->id_transaction ?? '') }}">

                        <div class="row g-3 mb-4">
                            <!-- Sales Order Information -->
                            <div class="col-md-4">
                                <label class="form-label">{{ $labels['id_transaction'] ?? 'Sales Order' }}</label>
                                <input type="text" class="form-control"
                                    value="{{ $salesOrder->code ?? ($model->transaction->code ?? '') }}" readonly>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Customer</label>
                                <input type="text" class="form-control"
                                    value="{{ $salesOrder->customer->full_name ?? ($model->transaction->customer->full_name ?? '') }}"
                                    readonly>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Invoice Date</label>
                                <input type="text" class="form-control"
                                    value="{{ $salesOrder->invoice_date ?? ($model->transaction->invoice_date ?? null) ? ($salesOrder->invoice_date ?? $model->transaction->invoice_date)->format('d/m/Y') : '' }}"
                                    readonly>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Route Details -->
                        <div class="row">
                            <div class="col-12">
                                <h6 class="mb-3">Assign Driver & Truck to Routes</h6>

                                @if ($model->id && $model->details->count() > 0)
                                    @php
                                        // Group details by route (id_detail)
                                        $groupedDetails = $model->details->groupBy('id_detail');
                                    @endphp

                                    @foreach ($groupedDetails as $idDetail => $detailGroup)
                                        @php
                                            $routeDetail = $detailGroup->first()->detail;
                                            $routeIndex = $loop->index;
                                        @endphp

                                        <div class="card mb-3 route-card" data-route-id="{{ $idDetail }}" data-route-qty="{{ $routeDetail->quantity ?? 0 }}">
                                            <div class="card-header bg-light route-header">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <strong>{{ $routeDetail->origin->name ?? '' }} →
                                                            {{ $routeDetail->destination->name ?? '' }}</strong>
                                                        <span
                                                            class="badge bg-secondary ms-2">{{ $routeDetail->loadout->name ?? '' }}</span>
                                                        <span class="badge bg-info ms-1">Total Quantity:
                                                            {{ $routeDetail->quantity ?? '' }}</span>
                                                        <span class="badge bg-warning ms-1 qty-assigned-badge" data-route-id="{{ $idDetail }}">
                                                            Assigned: <span class="qty-assigned-value">0</span> / {{ $routeDetail->quantity ?? '' }}
                                                        </span>
                                                        <span class="badge bg-primary ms-1">{{ $detailGroup->count() }}
                                                            Driver(s)</span>
                                                    </div>
                                                    <button type="button" class="btn btn-success btn-add-assignment"
                                                        data-route-id="{{ $idDetail }}">
                                                        <i class="icon-base ti tabler-plus"></i> Add Driver
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <!-- Desktop Table View -->
                                                <div class="table-responsive">
                                                    <table class="table table-sm table-bordered">
                                                        <thead>
                                                            <tr>
                                                                <th style="width: 1%;" class="text-nowrap">No</th>
                                                                <th>
                                                                    {{ $detailLabels['id_driver'] ?? 'Driver' }} <span
                                                                        class="text-danger">*</span></th>
                                                                <th>
                                                                    {{ $detailLabels['id_truck'] ?? 'Truck' }} <span
                                                                        class="text-danger">*</span></th>
                                                                <th style="width: 10%;" class="text-nowrap text-center">
                                                                    {{ $detailLabels['qty'] ?? 'Quantity' }}
                                                                    <span class="text-danger">*</span>
                                                                </th>
                                                                <th style="width: 1%;" class="text-nowrap text-center">
                                                                    {{ $detailLabels['delivery_date'] ?? 'Delivery Date' }}
                                                                    <span class="text-danger">*</span>
                                                                </th>
                                                                <th style="width: 1%;" class="text-nowrap"></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="assignment-container"
                                                            data-route-id="{{ $idDetail }}">
                                                            @foreach ($detailGroup as $detail)
                                                                @php
                                                                    $detailIndex = 'edit_' . $detail->id;
                                                                @endphp
                                                                <tr class="assignment-row"
                                                                    data-detail-id="{{ $detail->id }}">
                                                                    <td class="text-center">{{ $loop->iteration }}</td>
                                                                    <td>
                                                                        <input type="hidden"
                                                                            name="details[{{ $detailIndex }}][id]"
                                                                            value="{{ $detail->id }}">
                                                                        <input type="hidden"
                                                                            name="details[{{ $detailIndex }}][id_detail]"
                                                                            value="{{ $detail->id_detail }}">
                                                                        <select
                                                                            class="form-select select2 @error('details.' . $detailIndex . '.id_driver') is-invalid @enderror"
                                                                            name="details[{{ $detailIndex }}][id_driver]"
                                                                            required>
                                                                            <option value="">Select Driver</option>
                                                                            @foreach ($drivers as $driver)
                                                                                <option value="{{ $driver->id }}"
                                                                                    {{ $detail->id_driver == $driver->id ? 'selected' : '' }}>
                                                                                    {{ $driver->full_name }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select
                                                                            class="form-select select2 @error('details.' . $detailIndex . '.id_truck') is-invalid @enderror"
                                                                            name="details[{{ $detailIndex }}][id_truck]"
                                                                            required>
                                                                            <option value="">Select Truck</option>
                                                                            @foreach ($trucks as $truck)
                                                                                <option value="{{ $truck->id }}"
                                                                                    {{ $detail->id_truck == $truck->id ? 'selected' : '' }}>
                                                                                    {{ $truck->license_plate }} -
                                                                                    {{ $truck->type->name ?? '' }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number"
                                                                            class="form-control form-control-sm qty-input @error('details.' . $detailIndex . '.qty') is-invalid @enderror"
                                                                            name="details[{{ $detailIndex }}][qty]"
                                                                            value="{{ $detail->qty && $detail->qty > 0 ? $detail->qty : '' }}"
                                                                            min="1"
                                                                            data-route-id="{{ $detail->id_detail }}"
                                                                            required>
                                                                    </td>
                                                                    <td>
                                                                        <input type="date"
                                                                            class="form-control form-control-sm @error('details.' . $detailIndex . '.delivery_date') is-invalid @enderror"
                                                                            name="details[{{ $detailIndex }}][delivery_date]"
                                                                            value="{{ $detail->delivery_date ? $detail->delivery_date->format('Y-m-d') : '' }}"
                                                                            required>
                                                                    </td>
                                                                    <td class="text-center">
                                                                        <button type="button"
                                                                            class="btn btn-sm btn-danger btn-remove-assignment">
                                                                            <i class="icon-base ti tabler-trash"></i>
                                                                        </button>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <!-- Mobile Card View -->
                                                <div class="assignment-container-mobile" data-route-id="{{ $idDetail }}">
                                                    @foreach ($detailGroup as $detail)
                                                        @php
                                                            $detailIndex = 'edit_' . $detail->id;
                                                        @endphp
                                                        <div class="assignment-card-mobile" data-detail-id="{{ $detail->id }}">
                                                            <input type="hidden"
                                                                name="details[{{ $detailIndex }}][id]"
                                                                value="{{ $detail->id }}">
                                                            <input type="hidden"
                                                                name="details[{{ $detailIndex }}][id_detail]"
                                                                value="{{ $detail->id_detail }}">

                                                            <div class="form-group">
                                                                <label class="form-label">
                                                                    {{ $detailLabels['id_driver'] ?? 'Driver' }} <span class="text-danger">*</span>
                                                                </label>
                                                                <select
                                                                    class="form-select select2-mobile @error('details.' . $detailIndex . '.id_driver') is-invalid @enderror"
                                                                    name="details[{{ $detailIndex }}][id_driver]"
                                                                    required>
                                                                    <option value="">Select Driver</option>
                                                                    @foreach ($drivers as $driver)
                                                                        <option value="{{ $driver->id }}"
                                                                            {{ $detail->id_driver == $driver->id ? 'selected' : '' }}>
                                                                            {{ $driver->full_name }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label class="form-label">
                                                                    {{ $detailLabels['id_truck'] ?? 'Truck' }} <span class="text-danger">*</span>
                                                                </label>
                                                                <select
                                                                    class="form-select select2-mobile @error('details.' . $detailIndex . '.id_truck') is-invalid @enderror"
                                                                    name="details[{{ $detailIndex }}][id_truck]"
                                                                    required>
                                                                    <option value="">Select Truck</option>
                                                                    @foreach ($trucks as $truck)
                                                                        <option value="{{ $truck->id }}"
                                                                            {{ $detail->id_truck == $truck->id ? 'selected' : '' }}>
                                                                            {{ $truck->license_plate }} -
                                                                            {{ $truck->type->name ?? '' }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label class="form-label">
                                                                    {{ $detailLabels['qty'] ?? 'Quantity' }} <span class="text-danger">*</span>
                                                                </label>
                                                                <input type="number"
                                                                    class="form-control qty-input qty-input-mobile @error('details.' . $detailIndex . '.qty') is-invalid @enderror"
                                                                    data-sync-name="details[{{ $detailIndex }}][qty]"
                                                                    value="{{ $detail->qty && $detail->qty > 0 ? $detail->qty : '' }}"
                                                                    min="1"
                                                                    data-route-id="{{ $detail->id_detail }}">
                                                            </div>

                                                            <div class="form-group">
                                                                <label class="form-label">
                                                                    {{ $detailLabels['delivery_date'] ?? 'Delivery Date' }} <span class="text-danger">*</span>
                                                                </label>
                                                                <input type="date"
                                                                    class="form-control @error('details.' . $detailIndex . '.delivery_date') is-invalid @enderror"
                                                                    name="details[{{ $detailIndex }}][delivery_date]"
                                                                    value="{{ $detail->delivery_date ? $detail->delivery_date->format('Y-m-d') : '' }}"
                                                                    required>
                                                            </div>

                                                            <button type="button" class="btn btn-sm btn-danger btn-remove-assignment-mobile"
                                                                data-detail-id="{{ $detail->id }}">
                                                                <i class="icon-base ti tabler-trash"></i> Remove
                                                            </button>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    @foreach ($salesOrder->details as $salesDetail)
                                        @php
                                            $routeIndex = $loop->index;
                                        @endphp

                                        <div class="card mb-3 route-card" data-route-id="{{ $salesDetail->id }}" data-route-qty="{{ $salesDetail->quantity ?? 0 }}">
                                            <div class="card-header bg-light route-header">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <strong>{{ $salesDetail->origin->name ?? '' }} →
                                                            {{ $salesDetail->destination->name ?? '' }}</strong>
                                                        <span
                                                            class="badge bg-secondary ms-2">{{ $salesDetail->loadout->name ?? '' }}</span>
                                                        <span class="badge bg-info ms-1">Total Quantity:
                                                            {{ $salesDetail->quantity ?? '' }}</span>
                                                        <span class="badge bg-warning ms-1 qty-assigned-badge" data-route-id="{{ $salesDetail->id }}">
                                                            Assigned: <span class="qty-assigned-value">0</span> / {{ $salesDetail->quantity ?? '' }}
                                                        </span>
                                                    </div>
                                                    <button type="button" class="btn btn-success btn-add-assignment"
                                                        data-route-id="{{ $salesDetail->id }}">
                                                        <i class="icon-base ti tabler-plus"></i> Add Driver
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <!-- Desktop Table View -->
                                                <div class="table-responsive">
                                                    <table class="table table-sm table-bordered">
                                                        <thead>
                                                            <tr>
                                                                <th style="width: 1%;" class="text-nowrap">No</th>
                                                                <th>
                                                                    {{ $detailLabels['id_driver'] ?? 'Driver' }} <span
                                                                        class="text-danger">*</span></th>
                                                                <th>
                                                                    {{ $detailLabels['id_truck'] ?? 'Truck' }} <span
                                                                        class="text-danger">*</span></th>
                                                                <th style="width: 10%;" class="text-nowrap">
                                                                    {{ $detailLabels['qty'] ?? 'Qty' }}
                                                                    <span class="text-danger">*</span>
                                                                </th>
                                                                <th style="width: 1%;" class="text-nowrap">
                                                                    {{ $detailLabels['delivery_date'] ?? 'Delivery Date' }}
                                                                    <span class="text-danger">*</span>
                                                                </th>
                                                                <th style="width: 1%;" class="text-nowrap"></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="assignment-container"
                                                            data-route-id="{{ $salesDetail->id }}">
                                                            <tr class="assignment-row">
                                                                <td class="text-center">1</td>
                                                                <td>
                                                                    <input type="hidden"
                                                                        name="details[new_{{ $salesDetail->id }}_0][id_detail]"
                                                                        value="{{ $salesDetail->id }}">
                                                                    <select class="form-select select2"
                                                                        name="details[new_{{ $salesDetail->id }}_0][id_driver]"
                                                                        required>
                                                                        <option value="">Select Driver</option>
                                                                        @foreach ($drivers as $driver)
                                                                            <option value="{{ $driver->id }}">
                                                                                {{ $driver->full_name }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <select class="form-select select2"
                                                                        name="details[new_{{ $salesDetail->id }}_0][id_truck]"
                                                                        required>
                                                                        <option value="">Select Truck</option>
                                                                        @foreach ($trucks as $truck)
                                                                            <option value="{{ $truck->id }}">
                                                                                {{ $truck->license_plate }} -
                                                                                {{ $truck->type->name ?? '' }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <input type="number"
                                                                        class="form-control form-control-sm qty-input"
                                                                        name="details[new_{{ $salesDetail->id }}_0][qty]"
                                                                        min="1"
                                                                        data-route-id="{{ $salesDetail->id }}"
                                                                        required>
                                                                </td>
                                                                <td>
                                                                    <input type="date"
                                                                        class="form-control form-control-sm"
                                                                        name="details[new_{{ $salesDetail->id }}_0][delivery_date]"
                                                                        required>
                                                                </td>
                                                                <td class="text-center">
                                                                    <button type="button"
                                                                        class="btn btn-sm btn-danger btn-remove-assignment">
                                                                        <i class="icon-base ti tabler-trash"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <!-- Mobile Card View -->
                                                <div class="assignment-container-mobile" data-route-id="{{ $salesDetail->id }}">
                                                    <div class="assignment-card-mobile">
                                                        <input type="hidden"
                                                            name="details[new_{{ $salesDetail->id }}_0][id_detail]"
                                                            value="{{ $salesDetail->id }}">

                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ $detailLabels['id_driver'] ?? 'Driver' }} <span class="text-danger">*</span>
                                                            </label>
                                                            <select class="form-select select2-mobile"
                                                                name="details[new_{{ $salesDetail->id }}_0][id_driver]"
                                                                required>
                                                                <option value="">Select Driver</option>
                                                                @foreach ($drivers as $driver)
                                                                    <option value="{{ $driver->id }}">
                                                                        {{ $driver->full_name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ $detailLabels['id_truck'] ?? 'Truck' }} <span class="text-danger">*</span>
                                                            </label>
                                                            <select class="form-select select2-mobile"
                                                                name="details[new_{{ $salesDetail->id }}_0][id_truck]"
                                                                required>
                                                                <option value="">Select Truck</option>
                                                                @foreach ($trucks as $truck)
                                                                    <option value="{{ $truck->id }}">
                                                                        {{ $truck->license_plate }} -
                                                                        {{ $truck->type->name ?? '' }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ $detailLabels['qty'] ?? 'Qty' }} <span class="text-danger">*</span>
                                                            </label>
                                                            <input type="number"
                                                                class="form-control qty-input qty-input-mobile"
                                                                data-sync-name="details[new_{{ $salesDetail->id }}_0][qty]"
                                                                min="1"
                                                                data-route-id="{{ $salesDetail->id }}">
                                                        </div>

                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ $detailLabels['delivery_date'] ?? 'Delivery Date' }} <span class="text-danger">*</span>
                                                            </label>
                                                            <input type="date"
                                                                class="form-control"
                                                                name="details[new_{{ $salesDetail->id }}_0][delivery_date]"
                                                                required>
                                                        </div>

                                                        <button type="button" class="btn btn-sm btn-danger btn-remove-assignment-mobile">
                                                            <i class="icon-base ti tabler-trash"></i> Remove
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ $isBackUrl ?? route('delivery-order.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="delivery-order-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Delivery Order
        </button>
    </div>
@endsection

@section('page-script')
    <style>
        /* Add border to Select2 elements */
        .select2-container--bootstrap-5 .select2-selection {
            border: 1px solid #d9dee3 !important;
            min-height: 31px !important;
        }

        .select2-container--bootstrap-5 .select2-selection--single {
            padding: 0.25rem 0.5rem !important;
        }

        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
            padding-left: 0 !important;
            line-height: 1.5 !important;
        }

        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__arrow {
            height: 29px !important;
        }

        /* Make icons bigger and align properly */
        .btn {
            display: flex;
            align-items: center;
            gap: 4px;
        }

        .btn i.icon-base {
            font-size: 1.2rem;
        }

        /* Route card header responsive styles */
        .route-header .d-flex {
            gap: 10px;
        }

        .route-header .badge {
            white-space: nowrap;
        }

        /* Mobile responsive styles */
        @media (max-width: 768px) {
            .route-header .d-flex {
                flex-direction: column;
                align-items: flex-start !important;
            }

            .route-header .btn-add-assignment {
                width: 100%;
                margin-top: 10px;
                justify-content: center;
            }

            .route-header > div > div {
                flex-wrap: wrap;
                gap: 8px;
            }

            .route-header .badge {
                font-size: 0.75rem;
                padding: 4px 8px;
            }

            /* Hide table and show cards on mobile */
            .route-card .table-responsive {
                display: none;
            }

            .route-card .assignment-container-mobile {
                display: block;
            }
        }

        @media (min-width: 769px) {
            .assignment-container-mobile {
                display: none;
            }
        }

        /* Mobile card layout for assignments */
        .assignment-card-mobile {
            border: 1px solid #dee2e6;
            border-radius: 6px;
            padding: 1rem;
            margin-bottom: 1rem;
            background-color: #fff;
        }

        .assignment-card-mobile .form-group {
            margin-bottom: 1rem;
        }

        .assignment-card-mobile .form-label {
            font-weight: 600;
            font-size: 0.875rem;
            margin-bottom: 0.5rem;
            display: block;
        }

        .assignment-card-mobile .btn-remove-assignment-mobile {
            width: 100%;
            margin-top: 0.5rem;
        }

        @media (max-width: 576px) {
            .card-body {
                padding: 1rem;
            }

            .route-card .card-header {
                padding: 0.75rem;
            }

            h6 {
                font-size: 1rem;
            }
        }
    </style>

    <script>
        // Wait for DOM and jQuery to be ready
        document.addEventListener('DOMContentLoaded', function() {
            // Wait for jQuery to be available
            function initializeWhenReady() {
                if (typeof jQuery === 'undefined') {
                    setTimeout(initializeWhenReady, 50);
                    return;
                }

                // jQuery is ready, proceed with initialization
                $(document).ready(function() {
                    // Initialize select2 for desktop and mobile selects
                    function initializeSelect2() {
                        $('.select2').select2({
                            theme: 'bootstrap-5',
                            width: '100%'
                        });

                        // Initialize select2 for mobile selects (if screen is wide enough)
                        if (window.innerWidth > 768) {
                            $('.select2-mobile').select2({
                                theme: 'bootstrap-5',
                                width: '100%'
                            });
                        }
                    }

                    initializeSelect2();

                    // Handle required attribute and name attribute for mobile/desktop views
                    function updateRequiredAttributes() {
                        const isMobile = window.innerWidth <= 768;

                        if (isMobile) {
                            // On mobile, only mobile inputs should be required and have name attribute
                            $('.qty-input').not('.qty-input-mobile').each(function() {
                                $(this).removeAttr('required');
                                // Store name in data attribute and remove from input
                                if ($(this).attr('name')) {
                                    $(this).attr('data-stored-name', $(this).attr('name'));
                                    $(this).removeAttr('name');
                                }
                            });
                            $('.qty-input-mobile').each(function() {
                                $(this).attr('required', 'required');
                                // Restore name from data-sync-name
                                const syncName = $(this).attr('data-sync-name');
                                if (syncName) {
                                    $(this).attr('name', syncName);
                                }
                            });
                        } else {
                            // On desktop, only desktop inputs should be required and have name attribute
                            $('.qty-input').not('.qty-input-mobile').each(function() {
                                $(this).attr('required', 'required');
                                // Restore name from data-stored-name if exists
                                const storedName = $(this).attr('data-stored-name');
                                if (storedName) {
                                    $(this).attr('name', storedName);
                                }
                            });
                            $('.qty-input-mobile').each(function() {
                                $(this).removeAttr('required');
                                // Store name in data-sync-name and remove from input
                                if ($(this).attr('name')) {
                                    $(this).attr('data-sync-name', $(this).attr('name'));
                                    $(this).removeAttr('name');
                                }
                            });
                        }
                    }

                    // Sync values between desktop and mobile qty inputs
                    $(document).on('input change', '.qty-input', function() {
                        const $input = $(this);
                        const value = $input.val();
                        const isMobile = $input.hasClass('qty-input-mobile');
                        const name = $input.attr('name') || $input.attr('data-sync-name') || $input.attr('data-stored-name');
                        const routeId = $input.data('route-id');

                        if (!name) return;

                        // Find the corresponding input (desktop <-> mobile)
                        if (isMobile) {
                            // Sync from mobile to desktop
                            $(`.qty-input[name="${name}"], .qty-input[data-stored-name="${name}"]`).val(value);
                        } else {
                            // Sync from desktop to mobile
                            $(`.qty-input-mobile[data-sync-name="${name}"]`).val(value);
                        }

                        // Update qty badge after sync
                        if (routeId) {
                            updateQtyBadge(routeId);
                        }
                    });

                    // Update on load and resize
                    updateRequiredAttributes();
                    $(window).on('resize', updateRequiredAttributes);

                    // Track assignment counters for each route
                    const assignmentCounters = {};

                    // Add new assignment for a route
                    $(document).on('click', '.btn-add-assignment', function(e) {
                        e.preventDefault();
                        e.stopPropagation();

                        const routeId = $(this).data('route-id');
                        const $container = $(`.assignment-container[data-route-id="${routeId}"]`);
                        const $containerMobile = $(`.assignment-container-mobile[data-route-id="${routeId}"]`);
                        const currentCount = $container.find('tr').length;

                        // Initialize or increment counter
                        if (!assignmentCounters[routeId]) {
                            assignmentCounters[routeId] = currentCount;
                        }
                        assignmentCounters[routeId]++;

                        // Create new row for desktop
                        const newIndex = `new_${routeId}_${assignmentCounters[routeId]}`;
                        const newRow = `
                            <tr class="assignment-row">
                                <td class="text-center">${currentCount + 1}</td>
                                <td>
                                    <input type="hidden" name="details[${newIndex}][id_detail]" value="${routeId}">
                                    <select class="form-select select2" name="details[${newIndex}][id_driver]" required>
                                        <option value="">Select Driver</option>
                                        @foreach ($drivers as $driver)
                                            <option value="{{ $driver->id }}">{{ $driver->full_name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <select class="form-select select2" name="details[${newIndex}][id_truck]" required>
                                        <option value="">Select Truck</option>
                                        @foreach ($trucks as $truck)
                                            <option value="{{ $truck->id }}">{{ $truck->license_plate }} - {{ $truck->type->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <input type="number" class="form-control form-control-sm qty-input" name="details[${newIndex}][qty]" min="1" data-route-id="${routeId}" required>
                                </td>
                                <td>
                                    <input type="date" class="form-control form-control-sm" name="details[${newIndex}][delivery_date]" required>
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-sm btn-danger btn-remove-assignment">
                                        <i class="icon-base ti tabler-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        `;

                        // Create new card for mobile
                        const newCard = `
                            <div class="assignment-card-mobile">
                                <input type="hidden" name="details[${newIndex}][id_detail]" value="${routeId}">
                                <div class="form-group">
                                    <label class="form-label">Driver <span class="text-danger">*</span></label>
                                    <select class="form-select select2-mobile" name="details[${newIndex}][id_driver]" required>
                                        <option value="">Select Driver</option>
                                        @foreach ($drivers as $driver)
                                            <option value="{{ $driver->id }}">{{ $driver->full_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Truck <span class="text-danger">*</span></label>
                                    <select class="form-select select2-mobile" name="details[${newIndex}][id_truck]" required>
                                        <option value="">Select Truck</option>
                                        @foreach ($trucks as $truck)
                                            <option value="{{ $truck->id }}">{{ $truck->license_plate }} - {{ $truck->type->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Qty <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control qty-input qty-input-mobile" data-sync-name="details[${newIndex}][qty]" min="1" data-route-id="${routeId}">
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Delivery Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="details[${newIndex}][delivery_date]" required>
                                </div>
                                <button type="button" class="btn btn-sm btn-danger btn-remove-assignment-mobile">
                                    <i class="icon-base ti tabler-trash"></i> Remove
                                </button>
                            </div>
                        `;

                        $container.append(newRow);
                        $containerMobile.append(newCard);

                        // Initialize select2 for the new row's selects
                        $container.find('tr:last .select2').select2({
                            theme: 'bootstrap-5',
                            width: '100%'
                        });

                        // Initialize select2 for mobile only on desktop screens
                        if (window.innerWidth > 768) {
                            $containerMobile.find('.assignment-card-mobile:last .select2-mobile').select2({
                                theme: 'bootstrap-5',
                                width: '100%'
                            });
                        }

                        // Update assignment count badge
                        updateAssignmentBadge(routeId);

                        // Update qty badge
                        updateQtyBadge(routeId);

                        // Update row numbers
                        updateRowNumbers($container);

                        // Update required attributes for new inputs
                        updateRequiredAttributes();
                    });

                    // Remove assignment from desktop table
                    $(document).on('click', '.btn-remove-assignment', function() {
                        const $row = $(this).closest('tr');
                        const $container = $row.closest('.assignment-container');
                        const routeId = $container.data('route-id');
                        const $containerMobile = $(`.assignment-container-mobile[data-route-id="${routeId}"]`);
                        const rowIndex = $row.index();

                        if ($container.find('tr').length > 1) {
                            $row.remove();
                            $containerMobile.find('.assignment-card-mobile').eq(rowIndex).remove();
                            updateRowNumbers($container);
                            updateAssignmentBadge(routeId);
                            updateQtyBadge(routeId);
                        } else {
                            alert(
                                'At least one driver/truck assignment is required for each route.'
                            );
                        }
                    });

                    // Remove assignment from mobile card
                    $(document).on('click', '.btn-remove-assignment-mobile', function() {
                        const $card = $(this).closest('.assignment-card-mobile');
                        const $containerMobile = $card.closest('.assignment-container-mobile');
                        const routeId = $containerMobile.data('route-id');
                        const $container = $(`.assignment-container[data-route-id="${routeId}"]`);
                        const cardIndex = $card.index();

                        if ($containerMobile.find('.assignment-card-mobile').length > 1) {
                            $card.remove();
                            $container.find('tr').eq(cardIndex).remove();
                            updateRowNumbers($container);
                            updateAssignmentBadge(routeId);
                            updateQtyBadge(routeId);
                        } else {
                            alert(
                                'At least one driver/truck assignment is required for each route.'
                            );
                        }
                    });

                    // Update row numbers in a container
                    function updateRowNumbers($container) {
                        $container.find('tr').each(function(index) {
                            $(this).find('td:first').text(index + 1);
                        });
                    }

                    // Update assignment count badge
                    function updateAssignmentBadge(routeId) {
                        const count = $(`.assignment-container[data-route-id="${routeId}"]`).find('tr')
                            .length;
                        const $card = $(`.route-card[data-route-id="${routeId}"]`);
                        let $badge = $card.find('.badge.bg-primary');

                        if ($badge.length) {
                            $badge.text(`${count} Driver(s)`);
                        }
                    }

                    // Update qty assigned badge
                    function updateQtyBadge(routeId) {
                        let totalAssigned = 0;
                        const $card = $(`.route-card[data-route-id="${routeId}"]`);
                        const routeQty = parseInt($card.data('route-qty')) || 0;

                        // Sum all qty inputs for this route (only those with name attribute)
                        $(`.qty-input[data-route-id="${routeId}"][name]`).each(function() {
                            const qty = parseInt($(this).val()) || 0;
                            totalAssigned += qty;
                        });

                        const $badge = $(`.qty-assigned-badge[data-route-id="${routeId}"]`);
                        $badge.find('.qty-assigned-value').text(totalAssigned);

                        // Update badge color based on assignment status
                        $badge.removeClass('bg-warning bg-success bg-danger');
                        if (totalAssigned === 0) {
                            $badge.addClass('bg-warning');
                        } else if (totalAssigned === routeQty) {
                            $badge.addClass('bg-success');
                        } else if (totalAssigned > routeQty) {
                            $badge.addClass('bg-danger');
                        } else {
                            $badge.addClass('bg-warning');
                        }
                    }

                    // Validate all qty assignments before form submit
                    function validateQtyAssignments() {
                        let isValid = true;
                        let errorMessages = [];

                        $('.route-card').each(function() {
                            const routeId = $(this).data('route-id');
                            const routeQty = parseInt($(this).data('route-qty')) || 0;
                            let totalAssigned = 0;

                            // Only count qty inputs that have name attribute (active ones)
                            $(`.qty-input[data-route-id="${routeId}"][name]`).each(function() {
                                const qty = parseInt($(this).val()) || 0;
                                totalAssigned += qty;
                            });

                            const routeName = $(this).find('.route-header strong').text().trim();

                            if (totalAssigned === 0) {
                                isValid = false;
                                errorMessages.push(`Route "${routeName}": No quantity assigned. Please assign all ${routeQty} units.`);
                            } else if (totalAssigned < routeQty) {
                                isValid = false;
                                errorMessages.push(`Route "${routeName}": Only ${totalAssigned} of ${routeQty} units assigned. Please assign all ${routeQty} units.`);
                            } else if (totalAssigned > routeQty) {
                                isValid = false;
                                errorMessages.push(`Route "${routeName}": ${totalAssigned} units assigned exceeds the available ${routeQty} units.`);
                            }
                        });

                        if (!isValid) {
                            alert('Quantity Assignment Errors:\n\n' + errorMessages.join('\n\n'));
                        }

                        return isValid;
                    }

                    // Form submit validation
                    $('#delivery-order-form').on('submit', function(e) {
                        if (!validateQtyAssignments()) {
                            e.preventDefault();
                            return false;
                        }
                    });

                    // Initialize qty badges on page load
                    $('.route-card').each(function() {
                        const routeId = $(this).data('route-id');
                        updateQtyBadge(routeId);
                    });
                });
            }

            initializeWhenReady();
        });
    </script>
@endsection
