@extends('layouts.layoutMaster')

@section('title', 'Delivery Order Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('delivery-order.index'), 'label' => 'Delivery Order'],
        ['url' => route('delivery-order.show', ['delivery_order' => $model->id]), 'label' => $model->code],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Delivery Order Details</h5>
            <div>
                @can('delivery-order.update')
                    <a href="{{ route('delivery-order.edit', ['delivery_order' => $model->id]) }}" class="btn btn-sm btn-primary">
                        Edit
                    </a>
                @endcan
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Basic Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Basic Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Delivery Order Code</td>
                                    <td><strong>{{ $model->code }}</strong></td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Sales Order</td>
                                    <td>
                                        @if ($model->transaction)
                                            @can('sales-order.show')
                                                <a href="{{ route('sales-order.show', ['sales_order' => $model->transaction->id]) }}">
                                                    {{ $model->transaction->code }}
                                                </a>
                                            @else
                                                {{ $model->transaction->code }}
                                            @endcan
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Created Date</td>
                                    <td>{{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Customer & Sales Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Customer & Sales Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Customer</td>
                                    <td>
                                        @if ($model->transaction && $model->transaction->customer)
                                            @can('customer.show')
                                                <a href="{{ route('customer.show', ['customer' => $model->transaction->customer->id]) }}">
                                                    {{ $model->transaction->customer->full_name }}
                                                </a>
                                            @else
                                                {{ $model->transaction->customer->full_name }}
                                            @endcan
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Customer Phone</td>
                                    <td>{{ $model->transaction->customer->phone ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Sales Person</td>
                                    <td>{{ $model->transaction->sales->name ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Delivery Details -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Delivery Details</h6>

                    @php
                        // Group details by route (id_detail)
                        $groupedDetails = $model->details->groupBy('id_detail');
                    @endphp

                    @if($groupedDetails->count() > 0)
                        @foreach($groupedDetails as $idDetail => $detailGroup)
                            @php
                                $routeDetail = $detailGroup->first()->detail;
                            @endphp

                            <div class="card mb-3">
                                <div class="card-header bg-light">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>{{ $routeDetail->origin_name ?? '-' }} → {{ $routeDetail->destination_name ?? '-' }}</strong>
                                            <span class="badge bg-secondary ms-2">{{ $routeDetail->loadout->name ?? '-' }}</span>
                                            <span class="badge bg-info ms-1">Total Quantity: {{ \App\Helpers\Helpers::formatNumber($routeDetail->quantity ?? 0) }}</span>
                                            @php
                                                $totalAssigned = $detailGroup->sum('qty');
                                                $routeQty = $routeDetail->quantity ?? 0;
                                                $badgeColor = 'secondary';
                                                if ($totalAssigned == $routeQty) {
                                                    $badgeColor = 'success';
                                                } elseif ($totalAssigned > $routeQty) {
                                                    $badgeColor = 'danger';
                                                } elseif ($totalAssigned > 0) {
                                                    $badgeColor = 'warning';
                                                }
                                            @endphp
                                            <span class="badge bg-{{ $badgeColor }} ms-1">
                                                Assigned: {{ \App\Helpers\Helpers::formatNumber($totalAssigned) }} / {{ \App\Helpers\Helpers::formatNumber($routeQty) }}
                                            </span>
                                            <span class="badge bg-primary ms-1">{{ $detailGroup->count() }} Driver(s)</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-bordered">
                                            <thead>
                                                <tr>
                                                    <th style="width: 1%;" class="text-nowrap">No</th>
                                                    <th>Driver</th>
                                                    <th>Truck</th>
                                                    <th style="width: 10%;" class="text-nowrap text-center">Quantity</th>
                                                    <th style="width: 1%;" class="text-nowrap text-center">Delivery Date</th>
                                                    <th style="width: 1%;" class="text-nowrap text-center">Status</th>
                                                    <th style="width: 1%;" class="text-nowrap"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($detailGroup as $detail)
                                                    <tr>
                                                        <td class="text-center">{{ $loop->iteration }}</td>
                                                        <td>
                                                            @if($detail->driver)
                                                                @can('driver.show')
                                                                    <a href="{{ route('driver.show', ['driver' => $detail->driver->id]) }}">
                                                                        {{ $detail->driver->full_name }}
                                                                    </a>
                                                                @else
                                                                    {{ $detail->driver->full_name }}
                                                                @endcan
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if($detail->truck)
                                                                @can('truck.show')
                                                                    <a href="{{ route('truck.show', ['truck' => $detail->truck->id]) }}">
                                                                        {{ $detail->truck->license_plate }}
                                                                        @if($detail->truck->type)
                                                                            - {{ $detail->truck->type->name }}
                                                                        @endif
                                                                    </a>
                                                                @else
                                                                    {{ $detail->truck->license_plate }}
                                                                    @if($detail->truck->type)
                                                                        - {{ $detail->truck->type->name }}
                                                                    @endif
                                                                @endcan
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        </td>
                                                        <td class="text-center">{{ \App\Helpers\Helpers::formatNumber($detail->qty ?? 0) }}</td>
                                                        <td class="text-nowrap">{{ $detail->delivery_date?->format('d/m/Y') ?? '-' }}</td>
                                                        <td class="text-nowrap">
                                                            @php
                                                                $statusColors = [
                                                                    'pending' => 'secondary',
                                                                    'loading' => 'info',
                                                                    'ondelivery' => 'primary',
                                                                    'unloading' => 'warning',
                                                                    'onhold' => 'danger',
                                                                    'finish' => 'success'
                                                                ];
                                                                $statusColor = $statusColors[$detail->status] ?? 'secondary';
                                                            @endphp
                                                            <span class="badge bg-{{ $statusColor }}">{{ strtoupper($detail->status) }}</span>
                                                        </td>
                                                        <td class="text-center">
                                                            <button type="button" class="btn btn-sm btn-info btn-view-log"
                                                                    data-detail-id="{{ $detail->id }}"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#statusLogModal">
                                                                <i class="icon-base ti tabler-clock-hour-3"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="alert alert-info">No delivery details available</div>
                    @endif
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Log Modal -->
    <div class="modal fade" id="statusLogModal" tabindex="-1" aria-labelledby="statusLogModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header justify-content-center">
                    <h5 class="modal-title" id="statusLogModalLabel">Delivery Log</h5>
                    <button type="button" class="btn-close position-absolute end-0 me-3" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Content will be loaded here -->
                </div>
            </div>
        </div>
    </div>
@endsection
