@extends('layouts.driverLayout')

@section('title', 'Dashboard Driver')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Informasi Pengiriman</h4>
            </div>
            <div class="card-body">
                <!-- Driver Information -->
                <div class="mb-4">
                    <h5 class="text-primary">Informasi Driver</h5>
                    <table class="table table-borderless">
                        <tr>
                            <td width="150"><strong>Nama Driver</strong></td>
                            <td>: {{ $driver->name ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>No. HP</strong></td>
                            <td>: {{ $driver->phone ?? '-' }}</td>
                        </tr>
                    </table>
                </div>

                <!-- Truck Information -->
                <div class="mb-4">
                    <h5 class="text-primary">Informasi Kendaraan</h5>
                    <table class="table table-borderless">
                        <tr>
                            <td width="150"><strong>Nomor Polisi</strong></td>
                            <td>: {{ $truck->license_plate ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Tipe Truk</strong></td>
                            <td>: {{ $truck->truckType->name ?? '-' }}</td>
                        </tr>
                    </table>
                </div>

                <!-- Delivery Order Information -->
                <div class="mb-4">
                    <h5 class="text-primary">Informasi Pengiriman</h5>
                    <table class="table table-borderless">
                        <tr>
                            <td width="150"><strong>No. DO</strong></td>
                            <td>: {{ $deliveryOrder->do_number ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Tanggal Pengiriman</strong></td>
                            <td>: {{ $deliveryOrderDetail->delivery_date ? $deliveryOrderDetail->delivery_date->format('d/m/Y') : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status</strong></td>
                            <td>:
                                <span class="badge bg-{{ $deliveryOrderDetail->status == 'finish' ? 'success' : ($deliveryOrderDetail->status == 'ondelivery' ? 'primary' : 'warning') }}">
                                    {{ ucfirst($deliveryOrderDetail->status) }}
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Transaction Detail Information -->
                @if($transactionDetail)
                <div class="mb-4">
                    <h5 class="text-primary">Detail Transaksi</h5>
                    <table class="table table-borderless">
                        <tr>
                            <td width="150"><strong>Customer</strong></td>
                            <td>: {{ $transactionDetail->transaction->customer->name ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Rute</strong></td>
                            <td>: {{ $transactionDetail->route->origin ?? '-' }} - {{ $transactionDetail->route->destination ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Qty</strong></td>
                            <td>: {{ \App\Helpers\Helpers::formatNumber($transactionDetail->qty ?? 0) }} {{ $transactionDetail->unit ?? '' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Uang Jalan</strong></td>
                            <td>: {{ \App\Helpers\Helpers::formatCurrency($transactionDetail->pocket_money ?? 0) }}</td>
                        </tr>
                    </table>
                </div>
                @endif

                <!-- Status Update Form -->
                @if($deliveryOrderDetail->status != 'finish')
                <div class="mt-4">
                    <h5 class="text-primary">Update Status</h5>
                    <form id="updateStatusForm">
                        @csrf
                        <div class="mb-3">
                            <label for="status" class="form-label">Pilih Status Baru</label>
                            <select class="form-select form-select-lg" id="status" name="status" required>
                                <option value="">-- Pilih Status --</option>
                                <option value="loading" {{ $deliveryOrderDetail->status == 'loading' ? 'selected' : '' }}>Loading</option>
                                <option value="ondelivery" {{ $deliveryOrderDetail->status == 'ondelivery' ? 'selected' : '' }}>On Delivery</option>
                                <option value="unloading" {{ $deliveryOrderDetail->status == 'unloading' ? 'selected' : '' }}>Unloading</option>
                                <option value="onhold" {{ $deliveryOrderDetail->status == 'onhold' ? 'selected' : '' }}>On Hold</option>
                                <option value="finish" {{ $deliveryOrderDetail->status == 'finish' ? 'selected' : '' }}>Finish</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary btn-lg w-100">Update Status</button>
                    </form>
                </div>
                @else
                <div class="alert alert-success mt-4">
                    <h5 class="alert-heading">Pengiriman Selesai</h5>
                    <p class="mb-0">Pengiriman ini telah selesai. Terima kasih atas kerja sama Anda!</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('updateStatusForm');

    if (form) {
        form.addEventListener('submit', async function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const status = formData.get('status');

            if (!status) {
                alert('Silakan pilih status terlebih dahulu');
                return;
            }

            try {
                const response = await fetch('{{ route("driver.updateStatus") }}?token={{ request()->query("token") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({ status: status })
                });

                const data = await response.json();

                if (data.success) {
                    alert('Status berhasil diperbarui!');
                    window.location.reload();
                } else {
                    alert(data.message || 'Gagal memperbarui status');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Terjadi kesalahan saat memperbarui status');
            }
        });
    }
});
</script>
@endpush
@endsection
