@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Driver')

@php
$m = 'App\\Models\\Driver';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
['url' => route('dashboard'), 'label' => 'Dashboard'],
['url' => route('driver.index'), 'label' => 'Driver'],
];

if ($model->id) {
$breadcrumbs[] = [
'url' => route('driver.show', ['driver' => $model->id]),
'label' => $model->full_name,
];
$breadcrumbs[] = [
'url' => route('driver.edit', ['driver' => $model->id]),
'label' => 'Update Driver',
];
} else {
$breadcrumbs[] = [
'url' => route('driver.create'),
'label' => 'Create Driver',
];
}

@endphp

@section('content')
<div class="row form-row-with-sticky-actions">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white border-bottom">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Driver</h5>
                        <p class="text-muted mb-0 small">
                            {{ $model->id ? 'Update driver information' : 'Fill in the details below to create a new driver' }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="card-body pt-4">
                <form id="driver-form" method="POST"
                    action="{{ $model->id ? route('driver.update', ['driver' => $model->id]) : route('driver.store') }}"
                    enctype="multipart/form-data">
                    @csrf
                    @if ($model->id)
                    @method('PUT')
                    @endif

                    <div class="row g-3">
                        <!-- Code -->
                        <div class="col-md-6">
                            <label for="code" class="form-label">
                                {{ $labels['code'] ?? 'Driver Code' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('code') is-invalid @enderror"
                                id="code" name="code" value="{{ old('code', $model->code) }}"
                                required autofocus placeholder="Enter driver code">
                            @error('code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Full Name -->
                        <div class="col-md-6">
                            <label for="full_name" class="form-label">
                                {{ $labels['full_name'] ?? 'Full Name' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('full_name') is-invalid @enderror"
                                id="full_name" name="full_name" value="{{ old('full_name', $model->full_name) }}"
                                required placeholder="Enter driver full name">
                            @error('full_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Nick Name -->
                        <div class="col-md-6">
                            <label for="nick_name" class="form-label">{{ $labels['nick_name'] ?? 'Nick Name' }}</label>
                            <input type="text" class="form-control @error('nick_name') is-invalid @enderror"
                                id="nick_name" name="nick_name" value="{{ old('nick_name', $model->nick_name) }}"
                                placeholder="Enter driver nickname">
                            @error('nick_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Phone -->
                        <div class="col-md-6">
                            <label for="phone" class="form-label">
                                {{ $labels['phone'] ?? 'Phone' }} <span class="text-danger">*</span>
                            </label>
                            <input type="tel" class="form-control @error('phone') is-invalid @enderror"
                                id="phone" name="phone" value="{{ old('phone', $model->phone) }}" required
                                placeholder="08XX-XXXX-XXXX">
                            @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Address -->
                        <div class="col-12">
                            <label for="address" class="form-label">
                                {{ $labels['address'] ?? 'Address' }} <span class="text-danger">*</span>
                            </label>
                            <textarea class="form-control @error('address') is-invalid @enderror"
                                id="address" name="address" rows="2" required
                                placeholder="Street address, City, Province">{{ old('address', $model->address) }}</textarea>
                            @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Identity & License Information</h6>
                            </div>
                        </div>

                        <!-- Identity Number -->
                        <div class="col-md-4">
                            <label for="identity_number" class="form-label">
                                {{ $labels['identity_number'] ?? 'Identity Number (KTP)' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('identity_number') is-invalid @enderror"
                                id="identity_number" name="identity_number"
                                value="{{ old('identity_number', $model->identity_number) }}" required
                                placeholder="Enter KTP number">
                            @error('identity_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- License Number -->
                        <div class="col-md-4">
                            <label for="license_number" class="form-label">
                                {{ $labels['license_number'] ?? 'License Number (SIM)' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('license_number') is-invalid @enderror"
                                id="license_number" name="license_number"
                                value="{{ old('license_number', $model->license_number) }}" required
                                placeholder="Enter SIM number">
                            @error('license_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- License Type -->
                        <div class="col-md-4">
                            <label for="license_type" class="form-label">
                                {{ $labels['license_type'] ?? 'License Type' }} <span class="text-danger">*</span>
                            </label>
                            <select class="form-select @error('license_type') is-invalid @enderror"
                                id="license_type" name="license_type" required>
                                <option value="">-- Select Type --</option>
                                <option value="B1" {{ old('license_type', $model->license_type) == 'B1' ? 'selected' : '' }}>B1</option>
                                <option value="B1 UMUM" {{ old('license_type', $model->license_type) == 'B1 UMUM' ? 'selected' : '' }}>B1 UMUM</option>
                                <option value="B2" {{ old('license_type', $model->license_type) == 'B2' ? 'selected' : '' }}>B2</option>
                                <option value="B2 UMUM" {{ old('license_type', $model->license_type) == 'B2 UMUM' ? 'selected' : '' }}>B2 UMUM</option>
                            </select>
                            @error('license_type')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- License Date -->
                        <div class="col-md-4">
                            <label for="license_date" class="form-label">
                                {{ $labels['license_date'] ?? 'License Expiry Date' }} <span class="text-danger">*</span>
                            </label>
                            <input type="date" class="form-control @error('license_date') is-invalid @enderror"
                                id="license_date" name="license_date"
                                value="{{ old('license_date', $model->license_date?->format('Y-m-d')) }}" required>
                            @error('license_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- KK Number -->
                        <div class="col-md-4">
                            <label for="kk_number" class="form-label">{{ $labels['kk_number'] ?? 'Family Card Number (KK)' }}</label>
                            <input type="text" class="form-control @error('kk_number') is-invalid @enderror"
                                id="kk_number" name="kk_number"
                                value="{{ old('kk_number', $model->kk_number) }}"
                                placeholder="Enter KK number">
                            @error('kk_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- BPJS Number -->
                        <div class="col-md-4">
                            <label for="bpjs_number" class="form-label">{{ $labels['bpjs_number'] ?? 'BPJS Number' }}</label>
                            <input type="text" class="form-control @error('bpjs_number') is-invalid @enderror"
                                id="bpjs_number" name="bpjs_number"
                                value="{{ old('bpjs_number', $model->bpjs_number) }}"
                                placeholder="Enter BPJS number">
                            @error('bpjs_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Bank Information</h6>
                            </div>
                        </div>

                        <!-- Bank Name -->
                        <div class="col-md-4">
                            <label for="bank_name" class="form-label">{{ $labels['bank_name'] ?? 'Bank Name' }}</label>
                            <input type="text" class="form-control @error('bank_name') is-invalid @enderror"
                                id="bank_name" name="bank_name"
                                value="{{ old('bank_name', $model->bank_name) }}"
                                placeholder="e.g., BCA, Mandiri">
                            @error('bank_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Bank Account Number -->
                        <div class="col-md-4">
                            <label for="bank_no" class="form-label">{{ $labels['bank_no'] ?? 'Account Number' }}</label>
                            <input type="text" class="form-control @error('bank_no') is-invalid @enderror"
                                id="bank_no" name="bank_no"
                                value="{{ old('bank_no', $model->bank_no) }}"
                                placeholder="Enter account number">
                            @error('bank_no')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Bank Owner Name -->
                        <div class="col-md-4">
                            <label for="bank_owner_name" class="form-label">{{ $labels['bank_owner_name'] ?? 'Account Owner Name' }}</label>
                            <input type="text" class="form-control @error('bank_owner_name') is-invalid @enderror"
                                id="bank_owner_name" name="bank_owner_name"
                                value="{{ old('bank_owner_name', $model->bank_owner_name) }}"
                                placeholder="Enter account owner name">
                            @error('bank_owner_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Employment Information</h6>
                            </div>
                        </div>

                        <!-- Joined Date -->
                        <div class="col-md-6">
                            <label for="joined_date" class="form-label">
                                {{ $labels['joined_date'] ?? 'Joined Date' }} <span class="text-danger">*</span>
                            </label>
                            <input type="date" class="form-control @error('joined_date') is-invalid @enderror"
                                id="joined_date" name="joined_date"
                                value="{{ old('joined_date', $model->joined_date?->format('Y-m-d')) }}" required>
                            @error('joined_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Status -->
                        <div class="col-md-6">
                            <label for="status" class="form-label">
                                {{ $labels['status'] ?? 'Status' }} <span class="text-danger">*</span>
                            </label>
                            <select class="form-select @error('status') is-invalid @enderror"
                                id="status" name="status" required>
                                <option value="">-- Select Status --</option>
                                <option value="active" {{ old('status', $model->status) == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="blacklist" {{ old('status', $model->status) == 'blacklist' ? 'selected' : '' }}>Blacklist</option>
                                <option value="resigned" {{ old('status', $model->status) == 'resigned' ? 'selected' : '' }}>Resigned</option>
                            </select>
                            @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Notes -->
                        <div class="col-12">
                            <label for="notes" class="form-label">{{ $labels['notes'] ?? 'Notes' }}</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror"
                                id="notes" name="notes" rows="3"
                                placeholder="Additional notes about the driver">{{ old('notes', $model->notes) }}</textarea>
                            @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Document Files</h6>
                            </div>
                        </div>

                        <!-- Identity File -->
                        <div class="col-md-4">
                            <label for="identity_file" class="form-label">
                                Identity File (KTP) @if(!$model->id)<span class="text-danger">*</span>@endif
                            </label>
                            <input type="file" class="form-control @error('identity_file') is-invalid @enderror"
                                id="identity_file" name="identity_file" accept=".pdf,.jpg,.jpeg,.png" @if(!$model->id) required @endif>
                            @error('identity_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if($model->identity_file)
                            <small class="text-muted d-block mt-2">Current: <a href="{{ asset('storage/' . $model->identity_file) }}" target="_blank">View File</a></small>
                            @endif
                        </div>

                        <!-- License File -->
                        <div class="col-md-4">
                            <label for="license_file" class="form-label">
                                License File (SIM) @if(!$model->id)<span class="text-danger">*</span>@endif
                            </label>
                            <input type="file" class="form-control @error('license_file') is-invalid @enderror"
                                id="license_file" name="license_file" accept=".pdf,.jpg,.jpeg,.png" @if(!$model->id) required @endif>
                            @error('license_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if($model->license_file)
                            <small class="text-muted d-block mt-2">Current: <a href="{{ asset('storage/' . $model->license_file) }}" target="_blank">View File</a></small>
                            @endif
                        </div>

                        <!-- KK File -->
                        <div class="col-md-4">
                            <label for="kk_file" class="form-label">{{ $labels['kk_file'] ?? 'Family Card File (KK)' }}</label>
                            <input type="file" class="form-control @error('kk_file') is-invalid @enderror"
                                id="kk_file" name="kk_file" accept=".pdf,.jpg,.jpeg,.png">
                            @error('kk_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if($model->kk_file)
                            <small class="text-muted d-block mt-2">Current: <a href="{{ asset('storage/' . $model->kk_file) }}" target="_blank">View File</a></small>
                            @endif
                        </div>

                        <!-- Photo File -->
                        <div class="col-md-6">
                            <label for="photo_file" class="form-label">
                                Photo @if(!$model->id)<span class="text-danger">*</span>@endif
                            </label>
                            <input type="file" class="form-control @error('photo_file') is-invalid @enderror"
                                id="photo_file" name="photo_file" accept=".jpg,.jpeg,.png" @if(!$model->id) required @endif>
                            @error('photo_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if($model->photo_file)
                            <small class="text-muted d-block mt-2">Current: <a href="{{ asset('storage/' . $model->photo_file) }}" target="_blank">View File</a></small>
                            @endif
                        </div>

                        <!-- SKCK File -->
                        <div class="col-md-6">
                            <label for="skck_file" class="form-label">{{ $labels['skck_file'] ?? 'SKCK File' }}</label>
                            <input type="file" class="form-control @error('skck_file') is-invalid @enderror"
                                id="skck_file" name="skck_file" accept=".pdf,.jpg,.jpeg,.png">
                            @error('skck_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if($model->skck_file)
                            <small class="text-muted d-block mt-2">Current: <a href="{{ asset('storage/' . $model->skck_file) }}" target="_blank">View File</a></small>
                            @endif
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Form Actions - Sticky to bottom -->
<div class="form-actions-sticky">
    <a href="{{ route('driver.index') }}" class="btn btn-sm btn-label-secondary">
        Cancel
    </a>
    <button type="submit" form="driver-form" class="btn btn-sm btn-primary">
        {{ $model->id ? 'Update' : 'Create' }} Driver
    </button>
</div>
@endsection