@extends('layouts.layoutMaster')

@section('title', 'Driver Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('driver.index'), 'label' => 'Driver'],
        ['url' => route('driver.show', ['driver' => $model->id]), 'label' => $model->full_name],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Driver Details</h5>
            @can('driver.update')
                <a href="{{ route('driver.edit', ['driver' => $model->id]) }}" class="btn btn-sm btn-primary">
                    Edit
                </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Basic Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Basic Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Driver Code</td>
                                    <td>{{ $model->code }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Full Name</td>
                                    <td>{{ $model->full_name }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Nick Name</td>
                                    <td>{{ $model->nick_name ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Phone Number</td>
                                    <td>{{ $model->phone }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Address</td>
                                    <td>{{ $model->address }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Identity & License Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Identity & License Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Identity Number (KTP)</td>
                                    <td>{{ $model->identity_number }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">License Number (SIM)</td>
                                    <td>{{ $model->license_number }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">License Type</td>
                                    <td>{{ $model->license_type }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">License Expiry Date</td>
                                    <td>{{ $model->license_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Family Card (KK)</td>
                                    <td>{{ $model->kk_number ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">BPJS Number</td>
                                    <td>{{ $model->bpjs_number ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Bank Information -->
                <div class="col-lg-6 mt-4">
                    <h6 class="text-muted mb-3">Bank Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Bank Name</td>
                                    <td>{{ $model->bank_name ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Account Number</td>
                                    <td>{{ $model->bank_no ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Account Owner Name</td>
                                    <td>{{ $model->bank_owner_name ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Employment Information -->
                <div class="col-lg-6 mt-4">
                    <h6 class="text-muted mb-3">Employment Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Joined Date</td>
                                    <td>{{ $model->joined_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Status</td>
                                    <td>
                                        @php
                                            $statusClass = match ($model->status) {
                                                'active' => 'bg-success',
                                                'blacklist' => 'bg-danger',
                                                'resigned' => 'bg-warning',
                                                default => 'bg-secondary',
                                            };
                                            $statusLabel = match ($model->status) {
                                                'active' => 'Active',
                                                'blacklist' => 'Blacklist',
                                                'resigned' => 'Resigned',
                                                default => $model->status,
                                            };
                                        @endphp
                                        <span class="badge badge-sm {{ $statusClass }}">{{ $statusLabel }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Notes</td>
                                    <td>{{ $model->notes ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Document Files -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Document Files</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Identity File (KTP)</td>
                                    <td>
                                        @if ($model->identity_file)
                                            <a href="{{ asset('storage/' . $model->identity_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">License File (SIM)</td>
                                    <td>
                                        @if ($model->license_file)
                                            <a href="{{ asset('storage/' . $model->license_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Family Card File (KK)</td>
                                    <td>
                                        @if ($model->kk_file)
                                            <a href="{{ asset('storage/' . $model->kk_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Photo</td>
                                    <td>
                                        @if ($model->photo_file)
                                            <a href="{{ asset('storage/' . $model->photo_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">SKCK File</td>
                                    <td>
                                        @if ($model->skck_file)
                                            <a href="{{ asset('storage/' . $model->skck_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
