@extends('layouts.layoutMaster')

@section('title', 'Journal Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('journal.index'), 'label' => 'Journal'],
        ['url' => route('journal.show', ['journal' => $model->id]), 'label' => $model->code],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Journal Details</h5>
            @can('journal.update')
            <a href="{{ route('journal.edit', ['journal' => $model->id]) }}" class="btn btn-sm btn-primary">
                Edit
            </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Journal Information -->
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Code</td>
                                    <td>{{ $model->code }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Date</td>
                                    <td>{{ $model->date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Description</td>
                                    <td>{{ $model->description ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Account Journal Details -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Account Journal Details</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <thead style="background-color: #f8f9fa;">
                                <tr>
                                    <th>Account</th>
                                    <th class="text-end">Debit</th>
                                    <th class="text-end">Credit</th>
                                    <th>Description</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($model->accountJournals as $detail)
                                    <tr>
                                        <td>{{ $detail->account->code }} - {{ $detail->account->name }}</td>
                                        <td class="text-end">{{ \App\Helpers\Helpers::formatCurrency($detail->debit, 2) }}</td>
                                        <td class="text-end">{{ \App\Helpers\Helpers::formatCurrency($detail->credit, 2) }}</td>
                                        <td>{{ $detail->description ?: '-' }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center text-muted">No details available</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot style="background-color: #f8f9fa;">
                                <tr>
                                    <th class="text-end">Total:</th>
                                    <th class="text-end">{{ \App\Helpers\Helpers::formatCurrency($model->accountJournals->sum('debit'), 2) }}</th>
                                    <th class="text-end">{{ \App\Helpers\Helpers::formatCurrency($model->accountJournals->sum('credit'), 2) }}</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
