<!DOCTYPE html>
@php
    use Illuminate\Support\Str;
    use App\Helpers\Helpers;

    $menuFixed =
        $configData['layout'] === 'vertical'
            ? $menuFixed ?? ''
            : ($configData['layout'] === 'front'
                ? ''
                : $configData['headerType']);
    $navbarType =
        $configData['layout'] === 'vertical'
            ? $configData['navbarType']
            : ($configData['layout'] === 'front'
                ? 'layout-navbar-fixed'
                : '');
    $isFront = ($isFront ?? '') == true ? 'Front' : '';
    $contentLayout = isset($container) ? ($container === 'container-xxl' ? 'layout-compact' : 'layout-wide') : '';

    // Get skin name from configData - only applies to admin layouts
    $isAdminLayout = !Str::contains($configData['layout'] ?? '', 'front');
    $skinName = $isAdminLayout ? $configData['skinName'] ?? 'default' : 'default';

    // Get semiDark value from configData - only applies to admin layouts
    $semiDarkEnabled = $isAdminLayout && filter_var($configData['semiDark'] ?? false, FILTER_VALIDATE_BOOLEAN);

    // Generate primary color CSS if color is set
    $primaryColorCSS = '';
    if (isset($configData['color']) && $configData['color']) {
        $primaryColorCSS = Helpers::generatePrimaryColorCSS($configData['color']);
    }

@endphp

<html lang="{{ session()->get('locale') ?? app()->getLocale() }}"
    class="{{ $navbarType ?? '' }} {{ $contentLayout ?? '' }} {{ $menuFixed ?? '' }} {{ $menuCollapsed ?? '' }} {{ $footerFixed ?? '' }} {{ $customizerHidden ?? '' }}"
    dir="{{ $configData['textDirection'] }}" data-skin="{{ $skinName }}"
    data-assets-path="{{ asset('/assets') . '/' }}" data-base-url="{{ url('/') }}" data-framework="laravel"
    data-template="{{ $configData['layout'] }}-menu-template" data-bs-theme="{{ $configData['theme'] }}"
    @if ($isAdminLayout && $semiDarkEnabled) data-semidark-menu="true" @endif>
<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>
        @yield('title')
    </title>
    <meta name="description"
        content="{{ config('variables.templateDescription') ? config('variables.templateDescription') : '' }}" />
    <meta name="keywords"
        content="{{ config('variables.templateKeyword') ? config('variables.templateKeyword') : '' }}" />
    <meta property="og:title" content="{{ config('variables.ogTitle') ? config('variables.ogTitle') : '' }}" />
    <meta property="og:type" content="{{ config('variables.ogType') ? config('variables.ogType') : '' }}" />
    <meta property="og:url" content="{{ config('variables.productPage') ? config('variables.productPage') : '' }}" />
    <meta property="og:image" content="{{ config('variables.ogImage') ? config('variables.ogImage') : '' }}" />
    <meta property="og:description"
        content="{{ config('variables.templateDescription') ? config('variables.templateDescription') : '' }}" />
    <meta property="og:site_name"
        content="{{ config('variables.creatorName') ? config('variables.creatorName') : '' }}" />
    <meta name="robots" content="noindex, nofollow" />
    <!-- laravel CRUD token -->
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <!-- Canonical SEO -->
    <link rel="canonical" href="{{ config('variables.productPage') ? config('variables.productPage') : '' }}" />

    <!-- Flash Messages for Notifications -->
    @if (session('success'))
        <meta name="flash-success" content="{{ session('success') }}">
    @endif
    @if (session('error'))
        <meta name="flash-error" content="{{ session('error') }}">
    @endif
    @if (session('warning'))
        <meta name="flash-warning" content="{{ session('warning') }}">
    @endif
    @if (session('info'))
        <meta name="flash-info" content="{{ session('info') }}">
    @endif

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/img/favicon/favicon.ico') }}" />

    <!-- Include Styles -->
    <!-- $isFront is used to append the front layout styles only on the front layout otherwise the variable will be blank -->
    @include('layouts.sections.styles' . $isFront)

    @if (
        $primaryColorCSS &&
            (config('custom.custom.primaryColor') ||
                isset($_COOKIE['admin-primaryColor']) ||
                isset($_COOKIE['front-primaryColor'])))
        <!-- Primary Color Style -->
        <style id="primary-color-style">
            {!! $primaryColorCSS !!}
        </style>
    @endif

    <!-- Include Scripts for customizer, helper, analytics, config -->
    <!-- $isFront is used to append the front layout scriptsIncludes only on the front layout otherwise the variable will be blank -->
    @include('layouts.sections.scriptsIncludes' . $isFront)

    <!-- Custom Styles -->
    <style>
        /* Sticky form actions at bottom - full width with buttons on right */
        .form-actions-sticky {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            border-top: 1px solid #e0e0e0;
            background-color: white;
            padding: 1rem 2rem;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: flex-end;
            gap: 0.5rem;
        }

        /* Add padding to row container to prevent sticky actions from covering content */
        .form-row-with-sticky-actions {
            padding-bottom: 80px !important;
        }
    </style>
</head>

<body>
    <!-- Layout Content -->
    @yield('layoutContent')
    <!--/ Layout Content -->

    {{-- remove while creating package --}}
    {{-- remove while creating package end --}}

    <!-- Include Scripts -->
    <!-- $isFront is used to append the front layout scripts only on the front layout otherwise the variable will be blank -->
    @include('layouts/sections/scripts' . $isFront)

    @stack('scripts')
</body>

</html>
