@if (isset($breadcrumbs) || isset($isBackUrl))
    <div class="mb-4">
        {{-- Back Button --}}
        @if (isset($isBackUrl))
            <a href="{{ $isBackUrl }}"
                class="d-inline-flex align-items-center gap-2 text-decoration-none mb-3 hover-scale text-black">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                    <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        stroke-width="2" d="m15 6l-6 6l6 6" />
                </svg>
                <span class="fw-semibold">Back</span>
            </a>
        @endif

        {{-- Breadcrumb Navigation --}}
        @if (isset($breadcrumbs))
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 bg-transparent p-0 d-flex align-items-center">
                    @foreach ($breadcrumbs as $breadcrumb)
                        @if (!$loop->last)
                            <li class="breadcrumb-item d-flex align-items-center">
                                <a href="{{ $breadcrumb['url'] }}"
                                    class="text-muted text-decoration-none fw-normal small">
                                    {{ $breadcrumb['label'] }}
                                </a>
                                <span class="mx-2 text-muted d-flex align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        viewBox="0 0 24 24">
                                        <path fill="currentColor"
                                            d="M12 2c5.523 0 10 4.477 10 10a10 10 0 0 1-20 0C2 6.477 6.477 2 12 2m-.293 6.293a1 1 0 0 0-1.414 0l-.083.094a1 1 0 0 0 .083 1.32L12.585 12l-2.292 2.293a1 1 0 0 0 1.414 1.414l3-3a1 1 0 0 0 0-1.414z" />
                                    </svg>
                                </span>
                            </li>
                        @else
                            <li class="breadcrumb-item active small" aria-current="page">
                                <span class="text-black fw-semibold">{{ $breadcrumb['label'] }}</span>
                            </li>
                        @endif
                    @endforeach
                </ol>
            </nav>
        @endif
    </div>

    <style>
        .hover-scale {
            transition: transform 0.2s ease;
        }

        .hover-scale:hover {
            transform: translateX(-4px);
        }

        .breadcrumb-item+.breadcrumb-item::before {
            content: none;
        }

        .breadcrumb-item+.breadcrumb-item {
            padding-left: 0;
        }
    </style>
@endif
