@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Location')

@php
$m = 'App\\Models\\Location';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
['url' => route('dashboard'), 'label' => 'Dashboard'],
['url' => route('location.index'), 'label' => 'Locations'],
];

if ($model->id) {
$breadcrumbs[] = [
'url' => route('location.show', ['location' => $model->id]),
'label' => $model->name,
];
$breadcrumbs[] = [
'url' => route('location.edit', ['location' => $model->id]),
'label' => 'Update Location',
];
} else {
$breadcrumbs[] = [
'url' => route('location.create'),
'label' => 'Create Location',
];
}
@endphp

@section('content')
<div class="row form-row-with-sticky-actions">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white border-bottom">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Location</h5>
                        <p class="text-muted mb-0 small">
                            {{ $model->id ? 'Update location information' : 'Fill in the details below to create a new location' }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="card-body pt-4">
                <form id="location-form" method="POST"
                    action="{{ $model->id ? route('location.update', ['location' => $model->id]) : route('location.store') }}">
                    @csrf
                    @if ($model->id)
                    @method('PUT')
                    @endif

                    <div class="row g-3">
                        <!-- {{ $labels['name'] ?? 'Location Name' }} -->
                        <div class="col-12">
                            <label for="name" class="form-label">
                                {{ $labels['name'] ?? 'Location Name' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                id="name" name="name" value="{{ old('name', $model->name) }}"
                                required autofocus placeholder="Enter location name (e.g., Jakarta, Surabaya, Bandung)">
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">
                                Enter the city or area name that will be used as origin or destination in routes.
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Form Actions - Sticky to bottom -->
<div class="form-actions-sticky">
    <a href="{{ route('location.index') }}" class="btn btn-sm btn-label-secondary">
        Cancel
    </a>
    <button type="submit" form="location-form" class="btn btn-sm btn-primary">
        {{ $model->id ? 'Update' : 'Create' }} Location
    </button>
</div>
@endsection