@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Price')

@section('vendor-style')
    @vite('resources/assets/vendor/libs/select2/select2.scss')
@endsection

@section('vendor-script')
    @vite('resources/assets/vendor/libs/select2/select2.js')
@endsection

@section('page-script')
    @vite('resources/assets/js/forms-selects.js')
@endsection

@php
    $m = 'App\Models\Price';
    $labels = Helper::getModelLabels($m);

    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('price.index'), 'label' => 'Price'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('price.show', ['price' => $model->id]),
            'label' => 'Price #' . $model->id,
        ];
        $breadcrumbs[] = [
            'url' => route('price.edit', ['price' => $model->id]),
            'label' => 'Update Price',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('price.create'),
            'label' => 'Create Price',
        ];
    }

@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Price</h5>
                            <p class="text-muted mb-0 small">{{ $model->id ? 'Update price information' : 'Fill in the details below to create a new price' }}</p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
            <form id="price-form" method="POST" action="{{ $model->id ? route('price.update', ['price' => $model->id]) : route('price.store') }}">
                @csrf
                @if ($model->id)
                    @method('PUT')
                @endif

                <div class="row g-3">
                            <!-- Route -->
                            <div class="col-md-6">
                                <label for="id_route" class="form-label">
                                    {{ $labels['id_route'] ?? 'Route' }} <span class="text-danger">*</span>
                                </label>
                                <select class="form-select select2 @error('id_route') is-invalid @enderror" id="id_route" name="id_route" required autofocus>
                                    <option value="">-- Select Route --</option>
                                    @foreach($routes as $route)
                                        <option value="{{ $route->id }}" {{ old('id_route', $model->id_route) == $route->id ? 'selected' : '' }}>
                                            {{ $route->origin->name }} - {{ $route->destination->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('id_route')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Loadout -->
                            <div class="col-md-6">
                                <label for="id_loadout" class="form-label">
                                    {{ $labels['id_loadout'] ?? 'Loadout' }} <span class="text-danger">*</span>
                                </label>
                                <select class="form-select select2 @error('id_loadout') is-invalid @enderror" id="id_loadout" name="id_loadout" required>
                                    <option value="">-- Select Loadout --</option>
                                    @foreach($loadouts as $loadout)
                                        <option value="{{ $loadout->id }}" {{ old('id_loadout', $model->id_loadout) == $loadout->id ? 'selected' : '' }}>
                                            {{ $loadout->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('id_loadout')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Customer -->
                            <div class="col-md-6">
                                <label for="id_customer" class="form-label">
                                    {{ $labels['id_customer'] ?? 'Customer' }}
                                </label>
                                <select class="form-select select2 @error('id_customer') is-invalid @enderror" id="id_customer" name="id_customer">
                                    <option value="">-- Select Customer --</option>
                                    @foreach($customers as $customer)
                                        <option value="{{ $customer->id }}" {{ old('id_customer', $model->id_customer) == $customer->id ? 'selected' : '' }}>
                                            {{ $customer->full_name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('id_customer')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Price -->
                            <div class="col-md-6">
                                <label for="price" class="form-label">
                                    {{ $labels['price'] ?? 'Price' }} <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('price') is-invalid @enderror"
                                    id="price" name="price" value="{{ old('price', Helper::formatNumber($model->price)) }}" required
                                    placeholder="Enter price" data-format="number" data-submit-raw="true">
                                @error('price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Notes -->
                            <div class="col-12">
                                <label for="notes" class="form-label">{{ $labels['notes'] ?? 'Notes' }}</label>
                                <textarea class="form-control @error('notes') is-invalid @enderror"
                                    id="notes" name="notes" rows="2" maxlength="200"
                                    placeholder="Additional notes (max 200 characters)">{{ old('notes', $model->notes) }}</textarea>
                                @error('notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('price.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="price-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Price
        </button>
    </div>
@endsection
