@extends('layouts.layoutMaster')

@section('title', 'Price Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('price.index'), 'label' => 'Price'],
        ['url' => route('price.show', ['price' => $model->id]), 'label' => 'Price #' . $model->id],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Price Details</h5>
            @can('price.update')
                <a href="{{ route('price.edit', ['price' => $model->id]) }}" class="btn btn-sm btn-primary">
                    Edit
                </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Price Information -->
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Route</td>
                                    <td>{{ $model->route ? $model->route->origin->name . ' - ' . $model->route->destination->name : '-' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Loadout</td>
                                    <td>{{ $model->loadout->name ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Customer</td>
                                    <td>{{ $model->customer->full_name ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Price</td>
                                    <td>{{ \App\Helpers\Helpers::formatCurrency($model->price, 2) }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Notes</td>
                                    <td>{{ $model->notes ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
