@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Route')

@section('vendor-style')
    @vite('resources/assets/vendor/libs/select2/select2.scss')
@endsection

@section('vendor-script')
    @vite('resources/assets/vendor/libs/select2/select2.js')
@endsection

@section('page-script')
    @vite('resources/assets/js/forms-selects.js')
@endsection

@php
    $m = 'App\Models\Route';
    $labels = Helper::getModelLabels($m);

    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('route.index'), 'label' => 'Routes'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('route.show', ['route' => $model->id]),
            'label' => ($model->origin->name ?? '') . ' - ' . ($model->destination->name ?? ''),
        ];
        $breadcrumbs[] = [
            'url' => route('route.edit', ['route' => $model->id]),
            'label' => 'Update Route',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('route.create'),
            'label' => 'Create Route',
        ];
    }
@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Route</h5>
                            <p class="text-muted mb-0 small">
                                {{ $model->id ? 'Update route information' : 'Fill in the details below to create a new route' }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
                    <form id="route-form" method="POST"
                        action="{{ $model->id ? route('route.update', ['route' => $model->id]) : route('route.store') }}">
                        @csrf
                        @if ($model->id)
                            @method('PUT')
                        @endif

                        <div class="row g-3">
                            <!-- {{ $labels['id_origin'] ?? 'Origin Location' }} -->
                            <div class="col-md-6">
                                <label for="id_origin" class="form-label">
                                    {{ $labels['id_origin'] ?? 'Origin Location' }} <span class="text-danger">*</span>
                                </label>
                                <select class="form-select select2 @error('id_origin') is-invalid @enderror"
                                    id="id_origin" name="id_origin" required autofocus>
                                    <option value="">-- Select Origin --</option>
                                    @foreach($locations as $location)
                                        <option value="{{ $location->id }}"
                                            {{ old('id_origin', $model->id_origin) == $location->id ? 'selected' : '' }}>
                                            {{ $location->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('id_origin')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- {{ $labels['id_destination'] ?? 'Destination Location' }} -->
                            <div class="col-md-6">
                                <label for="id_destination" class="form-label">
                                    {{ $labels['id_destination'] ?? 'Destination Location' }} <span class="text-danger">*</span>
                                </label>
                                <select class="form-select select2 @error('id_destination') is-invalid @enderror"
                                    id="id_destination" name="id_destination" required>
                                    <option value="">-- Select Destination --</option>
                                    @foreach($locations as $location)
                                        <option value="{{ $location->id }}"
                                            {{ old('id_destination', $model->id_destination) == $location->id ? 'selected' : '' }}>
                                            {{ $location->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('id_destination')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Distance -->
                            <div class="col-md-4">
                                <label for="distance" class="form-label">
                                    {{ $labels['distance'] ?? 'Distance' }} (km) <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('distance') is-invalid @enderror"
                                    id="distance" name="distance" value="{{ old('distance', Helper::formatNumber($model->distance)) }}"
                                    required placeholder="Enter distance in kilometers" data-format="number" data-submit-raw="true">
                                @error('distance')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Duration -->
                            <div class="col-md-4">
                                <label for="duration" class="form-label">
                                    {{ $labels['duration'] ?? 'Duration' }} (hours) <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('duration') is-invalid @enderror"
                                    id="duration" name="duration" value="{{ old('duration', Helper::formatNumber($model->duration)) }}"
                                    required placeholder="Enter duration in hours" data-format="number" data-submit-raw="true">
                                @error('duration')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Toll -->
                            <div class="col-md-4">
                                <label for="toll" class="form-label">
                                    {{ $labels['toll'] ?? 'Toll Road' }} <span class="text-danger">*</span>
                                </label>
                                <select class="form-select @error('toll') is-invalid @enderror"
                                    id="toll" name="toll" required>
                                    <option value="">-- Select Type --</option>
                                    <option value="non" {{ old('toll', $model->toll) == 'non' ? 'selected' : '' }}>Non</option>
                                    <option value="full" {{ old('toll', $model->toll) == 'full' ? 'selected' : '' }}>Full</option>
                                    <option value="half" {{ old('toll', $model->toll) == 'half' ? 'selected' : '' }}>Half</option>
                                </select>
                                @error('toll')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Divider -->
                            <div class="col-12">
                                <div class="border-top pt-3 mt-2">
                                    <h6 class="text-muted mb-3">Driver Allowances</h6>
                                </div>
                            </div>

                            <!-- {{ $labels['pocket_money_1'] ?? 'Pocket Money 1' }} -->
                            <div class="col-md-4">
                                <label for="pocket_money_1" class="form-label">
                                    {{ $labels['pocket_money_1'] ?? 'Pocket Money 1' }} <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" class="form-control @error('pocket_money_1') is-invalid @enderror"
                                        id="pocket_money_1" name="pocket_money_1"
                                        value="{{ old('pocket_money_1', Helper::formatNumber($model->pocket_money_1)) }}"
                                        required placeholder="0" data-format="number" data-submit-raw="true">
                                    @error('pocket_money_1')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- {{ $labels['pocket_money_2'] ?? 'Pocket Money 2' }} -->
                            <div class="col-md-4">
                                <label for="pocket_money_2" class="form-label">{{ $labels['pocket_money_2'] ?? 'Pocket Money 2' }}</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" class="form-control @error('pocket_money_2') is-invalid @enderror"
                                        id="pocket_money_2" name="pocket_money_2"
                                        value="{{ old('pocket_money_2', Helper::formatNumber($model->pocket_money_2)) }}"
                                        placeholder="0" data-format="number" data-submit-raw="true">
                                    @error('pocket_money_2')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- {{ $labels['pocket_money_3'] ?? 'Pocket Money 3' }} -->
                            <div class="col-md-4">
                                <label for="pocket_money_3" class="form-label">{{ $labels['pocket_money_3'] ?? 'Pocket Money 3' }}</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" class="form-control @error('pocket_money_3') is-invalid @enderror"
                                        id="pocket_money_3" name="pocket_money_3"
                                        value="{{ old('pocket_money_3', Helper::formatNumber($model->pocket_money_3)) }}"
                                        placeholder="0" data-format="number" data-submit-raw="true">
                                    @error('pocket_money_3')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Bonus -->
                            <div class="col-md-6">
                                <label for="bonus" class="form-label">{{ $labels['bonus'] ?? 'Bonus' }}</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" class="form-control @error('bonus') is-invalid @enderror"
                                        id="bonus" name="bonus" value="{{ old('bonus', Helper::formatNumber($model->bonus)) }}"
                                        placeholder="0" data-format="number" data-submit-raw="true">
                                    @error('bonus')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('route.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="route-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Route
        </button>
    </div>
@endsection
