@extends('layouts.layoutMaster')

@section('title', 'Route Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('route.index'), 'label' => 'Routes'],
        [
            'url' => route('route.show', ['route' => $model->id]),
            'label' => ($model->origin->name ?? '') . ' - ' . ($model->destination->name ?? ''),
        ],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Route Details</h5>
            @can('route.update')
                <a href="{{ route('route.edit', ['route' => $model->id]) }}" class="btn btn-sm btn-primary">
                    Edit
                </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Route Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Route Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Origin Location</td>
                                    <td>{{ $model->origin->name ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Destination Location</td>
                                    <td>{{ $model->destination->name ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Distance</td>
                                    <td>{{ \App\Helpers\Helpers::formatNumber($model->distance, 2) }} km</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Duration</td>
                                    <td>{{ \App\Helpers\Helpers::formatNumber($model->duration) }} hours</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Toll Road</td>
                                    <td>
                                        @php
                                            $tollClass = match ($model->toll) {
                                                'full' => 'bg-success',
                                                'half' => 'bg-warning',
                                                'non' => 'bg-secondary',
                                                default => 'bg-secondary',
                                            };
                                            $tollLabel = match ($model->toll) {
                                                'full' => 'Full',
                                                'half' => 'Half',
                                                'non' => 'Non',
                                                default => $model->toll,
                                            };
                                        @endphp
                                        <span class="badge badge-sm {{ $tollClass }}">{{ $tollLabel }}</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Driver Allowances -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Driver Allowances</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Pocket Money 1</td>
                                    <td>{{ \App\Helpers\Helpers::formatCurrency($model->pocket_money_1, 2) }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Pocket Money 2</td>
                                    <td>{{ $model->pocket_money_2 ? \App\Helpers\Helpers::formatCurrency($model->pocket_money_2, 2) : '-' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Pocket Money 3</td>
                                    <td>{{ $model->pocket_money_3 ? \App\Helpers\Helpers::formatCurrency($model->pocket_money_3, 2) : '-' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Bonus</td>
                                    <td>{{ $model->bonus ? \App\Helpers\Helpers::formatCurrency($model->bonus, 2) : '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted"><strong>Total Allowance</strong></td>
                                    <td>
                                        <strong>
                                            {{ \App\Helpers\Helpers::formatCurrency(
                                                ($model->pocket_money_1 ?? 0) +
                                                    ($model->pocket_money_2 ?? 0) +
                                                    ($model->pocket_money_3 ?? 0) +
                                                    ($model->bonus ?? 0),
                                                2
                                            ) }}
                                        </strong>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
