@extends('layouts.layoutMaster')

@section('title', 'Sales Order Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('sales-order.index'), 'label' => 'Sales Order'],
        ['url' => route('sales-order.show', ['sales_order' => $model->id]), 'label' => $model->code],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Sales Order Details</h5>
            <div>
                @php
                    $hasDeliveryOrder = \App\Models\DeliveryOrder::where('id_transaction', $model->id)->exists();
                @endphp

                @if ($model->status === 'pending' && !$hasDeliveryOrder)
                    @can('delivery-order.create')
                        <a href="{{ route('delivery-order.create', ['sales_order' => $model->id]) }}"
                            class="btn btn-sm btn-success me-2">
                            Make Delivery Order
                        </a>
                    @endcan
                    @can('sales-order.update')
                        <a href="{{ route('sales-order.edit', ['sales_order' => $model->id]) }}" class="btn btn-sm btn-primary">
                            Edit
                        </a>
                    @endcan
                @endif

                @can('delivery-order.show')
                    @if ($hasDeliveryOrder)
                        @php
                            $deliveryOrder = \App\Models\DeliveryOrder::where('id_transaction', $model->id)->first();
                        @endphp
                        <a href="{{ route('delivery-order.show', ['delivery_order' => $deliveryOrder->id]) }}"
                            class="btn btn-sm btn-info me-2">
                            View Delivery Order
                        </a>
                    @endif
                @endcan
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Basic Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Basic Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Sales Order Code</td>
                                    <td><strong>{{ $model->code }}</strong></td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Quotation</td>
                                    <td>
                                        @if ($model->parentTransaction)
                                            @can('delivery-order.show')
                                                <a
                                                    href="{{ route('quotation.show', ['quotation' => $model->parentTransaction->id]) }}">
                                                    {{ $model->parentTransaction->code }}
                                                </a>
                                            @else
                                                {{ $model->parentTransaction->code }}
                                            @endcan
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Status</td>
                                    <td>
                                        <span
                                            class="badge badge-sm bg-{{ $model->getStatusColor() }}">{{ strtoupper($model->status) }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Invoice Date</td>
                                    <td>{{ $model->invoice_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Notes</td>
                                    <td>{{ $model->notes ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Customer & Sales Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Customer & Sales Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Customer</td>
                                    <td>
                                        @if ($model->customer)
                                            @can('customer.show')
                                                <a href="{{ route('customer.show', ['customer' => $model->customer->id]) }}">
                                                    {{ $model->customer->full_name }}
                                                </a>
                                            @else
                                                {{ $model->customer->full_name }}
                                            @endcan
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Customer Phone</td>
                                    <td>{{ $model->customer->phone ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Sales Person</td>
                                    <td>{{ $model->sales->name ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Transaction Details -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Sales Order Details</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered small">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 50px;">No</th>
                                    <th>Origin</th>
                                    <th>Destination</th>
                                    <th>Loadout</th>
                                    <th>Quantity</th>
                                    <th class="text-end">Price</th>
                                    <th class="text-end">Driver Allowance</th>
                                    <th class="text-end">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($model->details as $index => $detail)
                                    <tr>
                                        <td class="text-center">{{ $index + 1 }}</td>
                                        <td>{{ $detail->origin_name ?? ($detail->origin->name ?? '-') }}</td>
                                        <td>{{ $detail->destination_name ?? ($detail->destination->name ?? '-') }}</td>
                                        <td>{{ $detail->loadout->name ?? '-' }}</td>
                                        <td>{{ \App\Helpers\Helpers::formatNumber($detail->quantity) }}</td>
                                        <td class="text-end">
                                            {{ \App\Helpers\Helpers::formatCurrency($detail->price ?: 0, 2) }}
                                        </td>
                                        <td class="text-end">
                                            @php
                                                $totalAllowance =
                                                    ($detail->pocket_money_1 ?: 0) +
                                                    ($detail->pocket_money_2 ?: 0) +
                                                    ($detail->pocket_money_3 ?: 0) +
                                                    ($detail->bonus ?: 0);
                                            @endphp
                                            <button type="button" class="btn btn-sm btn-link text-primary p-0"
                                                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-html="true"
                                                data-bs-content="
                                                        <small>
                                                            <strong>Pocket Money 1:</strong> {{ \App\Helpers\Helpers::formatCurrency($detail->pocket_money_1 ?: 0, 2) }}<br>
                                                            <strong>Pocket Money 2:</strong> {{ \App\Helpers\Helpers::formatCurrency($detail->pocket_money_2 ?: 0, 2) }}<br>
                                                            <strong>Pocket Money 3:</strong> {{ \App\Helpers\Helpers::formatCurrency($detail->pocket_money_3 ?: 0, 2) }}<br>
                                                            <strong>Bonus:</strong> {{ \App\Helpers\Helpers::formatCurrency($detail->bonus ?: 0, 2) }}<br>
                                                            <hr class='my-1'>
                                                            <strong>Total:</strong> {{ \App\Helpers\Helpers::formatCurrency($totalAllowance, 2) }}
                                                        </small>
                                                    "
                                                title="Driver Allowance Details">
                                                {{ \App\Helpers\Helpers::formatCurrency($totalAllowance, 2) }}
                                                <i class="icon-base ti tabler-wallet ms-1"></i>
                                            </button>
                                        </td>
                                        <td class="text-end">
                                            {{ \App\Helpers\Helpers::formatCurrency($detail->sub_total ?: 0, 2) }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center text-muted">No details available</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Financial Summary -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Financial Summary</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Subtotal</td>
                                    <td class="text-end">
                                        <strong>{{ \App\Helpers\Helpers::formatCurrency($model->total ?: 0, 2) }}</strong>
                                    </td>
                                </tr>
                                @if ($model->ppn > 0)
                                    <tr>
                                        <td class="text-muted">PPN (VAT)
                                            {{ $model->ppn_percentage ? '(' . $model->ppn_percentage . '%)' : '' }}</td>
                                        <td class="text-end">
                                            {{ \App\Helpers\Helpers::formatCurrency($model->ppn ?: 0, 2) }}</td>
                                    </tr>
                                @endif
                                @if ($model->pph > 0)
                                    <tr>
                                        <td class="text-muted">PPh (Income Tax)
                                            {{ $model->pph_percentage ? '(' . $model->pph_percentage . '%)' : '' }}</td>
                                        <td class="text-end">-
                                            {{ \App\Helpers\Helpers::formatCurrency($model->pph ?: 0, 2) }}</td>
                                    </tr>
                                @endif
                                <tr>
                                    <td class="text-muted">Discount</td>
                                    <td class="text-end">-
                                        {{ \App\Helpers\Helpers::formatCurrency($model->discount ?: 0, 2) }}</td>
                                </tr>
                                <tr class="border-top">
                                    <td class="text-muted"><strong>Grand Total</strong></td>
                                    <td class="text-end"><strong
                                            class="text-primary fs-5">{{ \App\Helpers\Helpers::formatCurrency($model->grand_total ?: 0, 2) }}</strong>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-script')
    <script>
        // Initialize popovers
        document.addEventListener('DOMContentLoaded', function() {
            var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
            var popoverList = popoverTriggerList.map(function(popoverTriggerEl) {
                return new bootstrap.Popover(popoverTriggerEl);
            });
        });
    </script>
@endsection
