@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Truck Loadout')

@php
$m = 'App\\Models\\TruckLoadout';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('truck-loadout.index'), 'label' => 'Truck Loadout'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('truck-loadout.show', ['truck_loadout' => $model->id]),
            'label' => $model->name,
        ];
        $breadcrumbs[] = [
            'url' => route('truck-loadout.edit', ['truck_loadout' => $model->id]),
            'label' => 'Update Truck Loadout',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('truck-loadout.create'),
            'label' => 'Create Truck Loadout',
        ];
    }

@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Truck Loadout</h5>
                            <p class="text-muted mb-0 small">{{ $model->id ? 'Update truck loadout information' : 'Fill in the details below to create a new truck loadout' }}</p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
            <form id="truck-loadout-form" method="POST" action="{{ $model->id ? route('truck-loadout.update', ['truck_loadout' => $model->id]) : route('truck-loadout.store') }}">
                @csrf
                @if ($model->id)
                    @method('PUT')
                @endif

                <div class="row g-3">
                            <!-- Loadout Name -->
                            <div class="col-md-12">
                                <label for="name" class="form-label">
                                    {{ $labels['name'] ?? 'Loadout Name' }}
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    id="name" name="name" value="{{ old('name', $model->name) }}"
                                    placeholder="Enter loadout name" autofocus>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('truck-loadout.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="truck-loadout-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Truck Loadout
        </button>
    </div>
@endsection
