@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Truck Type')

@php
$m = 'App\\Models\\TruckType';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('truck-type.index'), 'label' => 'Truck Type'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('truck-type.show', ['truck_type' => $model->id]),
            'label' => $model->name,
        ];
        $breadcrumbs[] = [
            'url' => route('truck-type.edit', ['truck_type' => $model->id]),
            'label' => 'Update Truck Type',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('truck-type.create'),
            'label' => 'Create Truck Type',
        ];
    }

@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Truck Type</h5>
                            <p class="text-muted mb-0 small">
                                {{ $model->id ? 'Update truck type information' : 'Fill in the details below to create a new truck type' }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
                    <form id="truck-type-form" method="POST"
                        action="{{ $model->id ? route('truck-type.update', ['truck_type' => $model->id]) : route('truck-type.store') }}">
                        @csrf
                        @if ($model->id)
                            @method('PUT')
                        @endif

                        <div class="row g-3">
                            <!-- Name -->
                            <div class="col-12">
                                <label for="name" class="form-label">
                                    {{ $labels['name'] ?? 'Truck Type Name' }} <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    id="name" name="name" value="{{ old('name', $model->name) }}" required autofocus
                                    placeholder="Enter truck type name">
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('truck-type.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="truck-type-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Truck Type
        </button>
    </div>
@endsection
