@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' Truck')

@section('vendor-style')
    @vite('resources/assets/vendor/libs/select2/select2.scss')
@endsection

@section('vendor-script')
    @vite('resources/assets/vendor/libs/select2/select2.js')
@endsection

@section('page-script')
    @vite('resources/assets/js/forms-selects.js')
@endsection

@php
$m = 'App\\Models\\Truck';
$labels = Helper::getModelLabels($m);

$breadcrumbs = [
['url' => route('dashboard'), 'label' => 'Dashboard'],
['url' => route('truck.index'), 'label' => 'Truck'],
];

if ($model->id) {
$breadcrumbs[] = [
'url' => route('truck.show', ['truck' => $model->id]),
'label' => $model->license_plate,
];
$breadcrumbs[] = [
'url' => route('truck.edit', ['truck' => $model->id]),
'label' => 'Update Truck',
];
} else {
$breadcrumbs[] = [
'url' => route('truck.create'),
'label' => 'Create Truck',
];
}

@endphp

@section('content')
<div class="row form-row-with-sticky-actions">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white border-bottom">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} Truck</h5>
                        <p class="text-muted mb-0 small">
                            {{ $model->id ? 'Update truck information' : 'Fill in the details below to create a new truck' }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="card-body pt-4">
                <form id="truck-form" method="POST"
                    action="{{ $model->id ? route('truck.update', ['truck' => $model->id]) : route('truck.store') }}"
                    enctype="multipart/form-data">
                    @csrf
                    @if ($model->id)
                    @method('PUT')
                    @endif

                    <div class="row g-3">
                        <!-- Truck Type -->
                        <div class="col-md-6">
                            <label for="id_type" class="form-label">
                                {{ $labels['id_type'] ?? 'Truck Type' }} <span class="text-danger">*</span>
                            </label>
                            <select class="form-select select2 @error('id_type') is-invalid @enderror" id="id_type"
                                name="id_type" required autofocus>
                                <option value="">-- Select {{ $labels['id_type'] ?? 'Truck Type' }} --</option>
                                @foreach ($truckTypes as $type)
                                <option value="{{ $type->id }}"
                                    {{ old('id_type', $model->id_type) == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }}
                                </option>
                                @endforeach
                            </select>
                            @error('id_type')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Code -->
                        <div class="col-md-6">
                            <label for="code" class="form-label">
                                {{ $labels['code'] ?? 'Truck Code' }}
                            </label>
                            <input type="text" class="form-control @error('code') is-invalid @enderror"
                                id="code" name="code" value="{{ old('code', $model->code) }}"
                                placeholder="Enter truck code">
                            @error('code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Brand -->
                        <div class="col-md-4">
                            <label for="brand" class="form-label">
                                {{ $labels['brand'] ?? 'Brand' }}
                            </label>
                            <input type="text" class="form-control @error('brand') is-invalid @enderror"
                                id="brand" name="brand" value="{{ old('brand', $model->brand) }}"
                                placeholder="e.g., Hino, Mitsubishi">
                            @error('brand')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Body Number -->
                        <div class="col-md-4">
                            <label for="body_no" class="form-label">
                                {{ $labels['body_no'] ?? 'Body Number' }}
                            </label>
                            <input type="text" class="form-control @error('body_no') is-invalid @enderror"
                                id="body_no" name="body_no" value="{{ old('body_no', $model->body_no) }}"
                                placeholder="Enter body number">
                            @error('body_no')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Machine Number -->
                        <div class="col-md-4">
                            <label for="machine_no" class="form-label">
                                {{ $labels['machine_no'] ?? 'Machine Number' }}
                            </label>
                            <input type="text" class="form-control @error('machine_no') is-invalid @enderror"
                                id="machine_no" name="machine_no" value="{{ old('machine_no', $model->machine_no) }}"
                                placeholder="Enter machine number">
                            @error('machine_no')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Vehicle Year -->
                        <div class="col-md-3">
                            <label for="vehicle_year" class="form-label">
                                {{ $labels['vehicle_year'] ?? 'Vehicle Year' }}
                            </label>
                            <input type="text" class="form-control @error('vehicle_year') is-invalid @enderror"
                                id="vehicle_year" name="vehicle_year"
                                value="{{ old('vehicle_year', $model->vehicle_year) }}" maxlength="4"
                                placeholder="e.g., 2024">
                            @error('vehicle_year')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- License Plate -->
                        <div class="col-md-3">
                            <label for="license_plate" class="form-label">
                                {{ $labels['license_plate'] ?? 'License Plate' }} <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('license_plate') is-invalid @enderror"
                                id="license_plate" name="license_plate"
                                value="{{ old('license_plate', $model->license_plate) }}" required
                                placeholder="B 1234 ABC">
                            @error('license_plate')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- STNK Owner -->
                        <div class="col-md-6">
                            <label for="stnk_owner" class="form-label">
                                {{ $labels['stnk_owner'] ?? 'STNK Owner' }}
                            </label>
                            <input type="text" class="form-control @error('stnk_owner') is-invalid @enderror"
                                id="stnk_owner" name="stnk_owner" value="{{ old('stnk_owner', $model->stnk_owner) }}"
                                placeholder="Enter STNK owner name">
                            @error('stnk_owner')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- KIR Name -->
                        <div class="col-md-6">
                            <label for="kir_name" class="form-label">{{ $labels['kir_name'] ?? 'KIR Name' }}</label>
                            <input type="text" class="form-control @error('kir_name') is-invalid @enderror"
                                id="kir_name" name="kir_name" value="{{ old('kir_name', $model->kir_name) }}"
                                placeholder="Enter KIR name">
                            @error('kir_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Document Dates</h6>
                            </div>
                        </div>

                        <!-- Tax Date -->
                        <div class="col-md-4">
                            <label for="tax_date" class="form-label">
                                {{ $labels['tax_date'] ?? 'Tax Expiry Date' }}
                            </label>
                            <input type="date" class="form-control @error('tax_date') is-invalid @enderror"
                                id="tax_date" name="tax_date"
                                value="{{ old('tax_date', $model->tax_date?->format('Y-m-d')) }}">
                            @error('tax_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- KIR Date -->
                        <div class="col-md-4">
                            <label for="kir_date" class="form-label">
                                {{ $labels['kir_date'] ?? 'KIR Expiry Date' }}
                            </label>
                            <input type="date" class="form-control @error('kir_date') is-invalid @enderror"
                                id="kir_date" name="kir_date"
                                value="{{ old('kir_date', $model->kir_date?->format('Y-m-d')) }}">
                            @error('kir_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- STNK Date -->
                        <div class="col-md-4">
                            <label for="stnk_date" class="form-label">
                                {{ $labels['stnk_date'] ?? 'STNK Expiry Date' }}
                            </label>
                            <input type="date" class="form-control @error('stnk_date') is-invalid @enderror"
                                id="stnk_date" name="stnk_date"
                                value="{{ old('stnk_date', $model->stnk_date?->format('Y-m-d')) }}">
                            @error('stnk_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Credit & GPS Information</h6>
                            </div>
                        </div>

                        <!-- Credit Start Date -->
                        <div class="col-md-6">
                            <label for="credit_start_date"
                                class="form-label">{{ $labels['credit_start_date'] ?? 'Credit Start Date' }}</label>
                            <input type="date"
                                class="form-control @error('credit_start_date') is-invalid @enderror"
                                id="credit_start_date" name="credit_start_date"
                                value="{{ old('credit_start_date', $model->credit_start_date?->format('Y-m-d')) }}">
                            @error('credit_start_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Credit End Date -->
                        <div class="col-md-6">
                            <label for="credit_end_date"
                                class="form-label">{{ $labels['credit_end_date'] ?? 'Credit End Date' }}</label>
                            <input type="date" class="form-control @error('credit_end_date') is-invalid @enderror"
                                id="credit_end_date" name="credit_end_date"
                                value="{{ old('credit_end_date', $model->credit_end_date?->format('Y-m-d')) }}">
                            @error('credit_end_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- CCTV/GPS Number -->
                        <div class="col-md-6">
                            <label for="cctv_gps_no"
                                class="form-label">{{ $labels['cctv_gps_no'] ?? 'CCTV/GPS Number' }}</label>
                            <input type="text" class="form-control @error('cctv_gps_no') is-invalid @enderror"
                                id="cctv_gps_no" name="cctv_gps_no"
                                value="{{ old('cctv_gps_no', $model->cctv_gps_no) }}"
                                placeholder="Enter GPS device number">
                            @error('cctv_gps_no')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- GPS Contact -->
                        <div class="col-md-6">
                            <label for="gps_contact"
                                class="form-label">{{ $labels['gps_contact'] ?? 'GPS Contact' }}</label>
                            <input type="text" class="form-control @error('gps_contact') is-invalid @enderror"
                                id="gps_contact" name="gps_contact"
                                value="{{ old('gps_contact', $model->gps_contact) }}"
                                placeholder="GPS provider contact">
                            @error('gps_contact')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Notes -->
                        <div class="col-12">
                            <label for="note" class="form-label">{{ $labels['note'] ?? 'Notes' }}</label>
                            <textarea class="form-control @error('note') is-invalid @enderror" id="note" name="note" rows="2"
                                placeholder="Additional notes about the truck">{{ old('note', $model->note) }}</textarea>
                            @error('note')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Divider -->
                        <div class="col-12">
                            <div class="border-top pt-3 mt-2">
                                <h6 class="text-muted mb-3">Document Files</h6>
                            </div>
                        </div>

                        <!-- KIR File -->
                        <div class="col-md-4">
                            <label for="kir_file"
                                class="form-label">{{ $labels['kir_file'] ?? 'KIR File' }}</label>
                            <input type="file" class="form-control @error('kir_file') is-invalid @enderror"
                                id="kir_file" name="kir_file" accept=".pdf,.jpg,.jpeg,.png">
                            @error('kir_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if ($model->kir_file)
                            <small class="text-muted d-block mt-2">Current: <a
                                    href="{{ asset('storage/' . $model->kir_file) }}" target="_blank">View
                                    File</a></small>
                            @endif
                        </div>

                        <!-- BPKB File -->
                        <div class="col-md-4">
                            <label for="bpkb_file"
                                class="form-label">{{ $labels['bpkb_file'] ?? 'BPKB File' }}</label>
                            <input type="file" class="form-control @error('bpkb_file') is-invalid @enderror"
                                id="bpkb_file" name="bpkb_file" accept=".pdf,.jpg,.jpeg,.png">
                            @error('bpkb_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if ($model->bpkb_file)
                            <small class="text-muted d-block mt-2">Current: <a
                                    href="{{ asset('storage/' . $model->bpkb_file) }}" target="_blank">View
                                    File</a></small>
                            @endif
                        </div>

                        <!-- STNK File -->
                        <div class="col-md-4">
                            <label for="stnk_file"
                                class="form-label">{{ $labels['stnk_file'] ?? 'STNK File' }}</label>
                            <input type="file" class="form-control @error('stnk_file') is-invalid @enderror"
                                id="stnk_file" name="stnk_file" accept=".pdf,.jpg,.jpeg,.png">
                            @error('stnk_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if ($model->stnk_file)
                            <small class="text-muted d-block mt-2">Current: <a
                                    href="{{ asset('storage/' . $model->stnk_file) }}" target="_blank">View
                                    File</a></small>
                            @endif
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('truck.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="truck-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} Truck
        </button>
    </div>
    @endsection