@extends('layouts.layoutMaster')

@section('title', 'Truck')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'])
@endsection

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('truck.index'), 'label' => 'Truck'],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-datatable table-responsive">
            <x-datatable id="truck-table" title="Truck" resource="truck" :create_url="route('truck.create')" :url="route('truck.data')" :columns="$columns"
                :filters="$filters" :order="[[$defaultOrder['order_by'], $defaultOrder['order_mode']]]" :page-length="25" :searchable="true" :exportable="true">
            </x-datatable>
        </div>
    </div>
@endsection
