@extends('layouts.layoutMaster')

@section('title', 'Truck Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('truck.index'), 'label' => 'Truck'],
        ['url' => route('truck.show', ['truck' => $model->id]), 'label' => $model->license_plate],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Truck Details</h5>
            @can('truck.update')
                <a href="{{ route('truck.edit', ['truck' => $model->id]) }}" class="btn btn-sm btn-primary">
                    Edit
                </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Basic Information -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Basic Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Truck Type</td>
                                    <td>{{ $model->type->name ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Truck Code</td>
                                    <td>{{ $model->code ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Brand</td>
                                    <td>{{ $model->brand ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Body Number</td>
                                    <td>{{ $model->body_no ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Machine Number</td>
                                    <td>{{ $model->machine_no ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Vehicle Year</td>
                                    <td>{{ $model->vehicle_year ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">License Plate</td>
                                    <td>{{ $model->license_plate }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">STNK Owner</td>
                                    <td>{{ $model->stnk_owner ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">KIR Name</td>
                                    <td>{{ $model->kir_name ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Notes</td>
                                    <td>{{ $model->note ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Document Dates -->
                <div class="col-lg-6">
                    <h6 class="text-muted mb-3">Document Dates</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Tax Date</td>
                                    <td>{{ $model->tax_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">KIR Date</td>
                                    <td>{{ $model->kir_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">STNK Date</td>
                                    <td>{{ $model->stnk_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Credit & GPS Information -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Credit & GPS Information</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Credit Start Date</td>
                                    <td>{{ $model->credit_start_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Credit End Date</td>
                                    <td>{{ $model->credit_end_date?->format('d/m/Y') ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">CCTV/GPS Number</td>
                                    <td>{{ $model->cctv_gps_no ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">GPS Contact</td>
                                    <td>{{ $model->gps_contact ?: '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Document Files -->
                <div class="col-12 mt-4">
                    <h6 class="text-muted mb-3">Document Files</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">KIR File</td>
                                    <td>
                                        @if ($model->kir_file)
                                            <a href="{{ asset('storage/' . $model->kir_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">BPKB File</td>
                                    <td>
                                        @if ($model->bpkb_file)
                                            <a href="{{ asset('storage/' . $model->bpkb_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">STNK File</td>
                                    <td>
                                        @if ($model->stnk_file)
                                            <a href="{{ asset('storage/' . $model->stnk_file) }}" target="_blank"
                                                class="btn btn-sm btn-outline-primary">
                                                View File
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
