@extends('layouts.layoutMaster')

@section('title', ($model->id ? 'Update' : 'Create') . ' User')

@section('vendor-style')
    @vite('resources/assets/vendor/libs/select2/select2.scss')
@endsection

@section('vendor-script')
    @vite('resources/assets/vendor/libs/select2/select2.js')
@endsection

@section('page-script')
    @vite('resources/assets/js/forms-selects.js')
@endsection

@php
    $m = 'App\Models\User';
    $labels = Helper::getModelLabels($m);

    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('user.index'), 'label' => 'User'],
    ];

    if ($model->id) {
        $breadcrumbs[] = [
            'url' => route('user.show', ['user' => $model->id]),
            'label' => $model->name,
        ];
        $breadcrumbs[] = [
            'url' => route('user.edit', ['user' => $model->id]),
            'label' => 'Update User',
        ];
    } else {
        $breadcrumbs[] = [
            'url' => route('user.create'),
            'label' => 'Create User',
        ];
    }

@endphp

@section('content')
    <div class="row form-row-with-sticky-actions">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">{{ $model->id ? 'Edit' : 'New' }} User</h5>
                            <p class="text-muted mb-0 small">
                                {{ $model->id ? 'Update user information' : 'Fill in the details below to create a new user' }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-4">
                    <form id="user-form" method="POST"
                        action="{{ $model->id ? route('user.update', ['user' => $model->id]) : route('user.store') }}">
                        @csrf
                        @if ($model->id)
                            @method('PUT')
                        @endif

                        <div class="row g-3">
                            <!-- Name -->
                            <div class="col-md-4">
                                <label for="name" class="form-label">
                                    {{ $labels['name'] ?? 'Full Name' }} <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    id="name" name="name" value="{{ old('name', $model->name) }}" required autofocus
                                    placeholder="Enter full name">
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Username -->
                            <div class="col-md-4">
                                <label for="username" class="form-label">
                                    Username <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control @error('username') is-invalid @enderror"
                                    id="username" name="username" value="{{ old('username', $model->username) }}" required
                                    placeholder="Enter username">
                                @error('username')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Role -->
                            <div class="col-md-4">
                                <label for="role_id" class="form-label">
                                    Role <span class="text-danger">*</span>
                                </label>
                                <select class="form-select select2 @error('role_id') is-invalid @enderror" id="role_id"
                                    name="role_id" required>
                                    <option value="">-- Select Role --</option>
                                    @foreach ($roles as $role)
                                        <option value="{{ $role->id }}"
                                            {{ old('role_id', $model->roles->first()?->id) == $role->id ? 'selected' : '' }}>
                                            {{ $role->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('role_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Password -->
                            <div class="col-md-6">
                                <label for="password" class="form-label">
                                    Password @if (!$model->id)
                                        <span class="text-danger">*</span>
                                    @endif
                                </label>
                                <input type="password" class="form-control @error('password') is-invalid @enderror"
                                    id="password" name="password"
                                    placeholder="{{ $model->id ? 'Leave blank to keep current password' : 'Enter password' }}"
                                    {{ !$model->id ? 'required' : '' }}>
                                @error('password')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                @if ($model->id)
                                    <small class="text-muted d-block mt-1">Leave blank if you don't want to change the
                                        password</small>
                                @endif
                            </div>

                            <!-- Confirm Password -->
                            <div class="col-md-6">
                                <label for="password_confirmation" class="form-label">
                                    Confirm Password @if (!$model->id)
                                        <span class="text-danger">*</span>
                                    @endif
                                </label>
                                <input type="password"
                                    class="form-control @error('password_confirmation') is-invalid @enderror"
                                    id="password_confirmation" name="password_confirmation"
                                    placeholder="{{ $model->id ? 'Leave blank to keep current password' : 'Confirm password' }}"
                                    {{ !$model->id ? 'required' : '' }}>
                                @error('password_confirmation')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Actions - Sticky to bottom -->
    <div class="form-actions-sticky">
        <a href="{{ route('user.index') }}" class="btn btn-sm btn-label-secondary">
            Cancel
        </a>
        <button type="submit" form="user-form" class="btn btn-sm btn-primary">
            {{ $model->id ? 'Update' : 'Create' }} User
        </button>
    </div>
@endsection
