@extends('layouts.layoutMaster')

@section('title', 'User Detail')

@php
    $breadcrumbs = [
        ['url' => route('dashboard'), 'label' => 'Dashboard'],
        ['url' => route('user.index'), 'label' => 'User'],
        ['url' => route('user.show', ['user' => $model->id]), 'label' => $model->name],
    ];
@endphp

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">User Details</h5>
            @can('user.update')
                <a href="{{ route('user.edit', ['user' => $model->id]) }}" class="btn btn-sm btn-primary">
                    Edit
                </a>
            @endcan
        </div>
        <div class="card-body">
            <div class="row">
                <!-- User Information -->
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless small">
                            <tbody>
                                <tr>
                                    <td width="200" class="text-muted">Full Name</td>
                                    <td>{{ $model->name }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Username</td>
                                    <td>{{ $model->username }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Role</td>
                                    <td>
                                        @if ($model->roles->count() > 0)
                                            @foreach ($model->roles as $role)
                                                <span class="badge badge-sm bg-primary">{{ $role->name }}</span>
                                            @endforeach
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Audit Information -->
                <div class="col-12 mt-4 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $model->created_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->createdBy)
                                    by {{ $model->createdBy->name }}
                                @endif
                            </small>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $model->updated_at?->format('d/m/Y H:i') ?? '-' }}
                                @if ($model->updatedBy)
                                    by {{ $model->updatedBy->name }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
