<?php

use App\Http\Controllers\CustomerController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TruckController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\DriverController;
use App\Http\Controllers\RouteController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\TruckTypeController;
use App\Http\Controllers\TruckLoadoutController;
use App\Http\Controllers\PriceController;
use App\Http\Controllers\QuotationController;
use App\Http\Controllers\SalesOrderController;
use App\Http\Controllers\DeliveryOrderController;
use App\Http\Controllers\AccountCategoryController;
use App\Http\Controllers\AccountTypeController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\JournalController;
use App\Http\Controllers\DriverDashboardController;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\ActivityLogController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')->group(function () {
    Route::get("/", [DashboardController::class, "index"])->name("dashboard");

    // Master Routes
    Route::prefix('master')->group(function () {
        // AJAX Data Routes
        Route::get('/customer/data', [CustomerController::class, 'getData'])->name('customer.data');
        Route::get('/truck-type/data', [TruckTypeController::class, 'getData'])->name('truck-type.data');
        Route::get('/truck/data', [TruckController::class, 'getData'])->name('truck.data');
        Route::get('/truck-loadout/data', [TruckLoadoutController::class, 'getData'])->name('truck-loadout.data');
        Route::get('/user/data', [UserController::class, 'getData'])->name('user.data');
        Route::get('/role/data', [RoleController::class, 'getData'])->name('role.data');
        Route::get('/driver/data', [DriverController::class, 'getData'])->name('driver.data');
        Route::get('/route/data', [RouteController::class, 'getData'])->name('route.data');
        Route::get('/location/data', [LocationController::class, 'getData'])->name('location.data');
        Route::get('/price/data', [PriceController::class, 'getData'])->name('price.data');
        Route::get('/config/data', [ConfigController::class, 'getData'])->name('config.data');

        // Resource Routes
        Route::resource('customer', CustomerController::class);
        Route::resource('truck', TruckController::class);
        Route::resource('truck-type', TruckTypeController::class);
        Route::resource('truck-loadout', TruckLoadoutController::class);
        Route::resource('user', UserController::class);
        Route::resource('role', RoleController::class);
        Route::resource('driver', DriverController::class);
        Route::resource('route', RouteController::class);
        Route::resource('location', LocationController::class);
        Route::resource('price', PriceController::class);
        Route::resource('config', ConfigController::class);
    });

    // Transaction Routes
    Route::prefix('transaction')->group(function () {
        // Quotation AJAX routes
        Route::get('/quotation/get-prices', [QuotationController::class, 'getPrices'])->name('quotation.get-prices');
        Route::get('/quotation/get-route-allowances', [QuotationController::class, 'getRouteAllowances'])->name('quotation.get-route-allowances');
        Route::get('/quotation/data', [QuotationController::class, 'getData'])->name('quotation.data');
        Route::post('/quotation/{quotation}/reject', [QuotationController::class, 'reject'])->name('quotation.reject');

        // Sales Order AJAX routes
        Route::get('/sales-order/get-prices', [SalesOrderController::class, 'getPrices'])->name('sales-order.get-prices');
        Route::get('/sales-order/get-route-allowances', [SalesOrderController::class, 'getRouteAllowances'])->name('sales-order.get-route-allowances');
        Route::get('/sales-order/data', [SalesOrderController::class, 'getData'])->name('sales-order.data');

        // Delivery Order AJAX routes
        Route::get('/delivery-order/data', [DeliveryOrderController::class, 'getData'])->name('delivery-order.data');
        Route::get('/delivery-order/create/{sales_order}', [DeliveryOrderController::class, 'create'])->name('delivery-order.create');

        Route::resource('quotation', QuotationController::class);
        Route::resource('sales-order', SalesOrderController::class);
        Route::resource('delivery-order', DeliveryOrderController::class)->except(['create']);
    });

    // Accounting Routes
    Route::prefix('accounting')->group(function () {
        // AJAX Data Routes
        Route::get('/account-category/data', [AccountCategoryController::class, 'getData'])->name('account-category.data');
        Route::get('/account-type/data', [AccountTypeController::class, 'getData'])->name('account-type.data');
        Route::get('/account/data', [AccountController::class, 'getData'])->name('account.data');
        Route::get('/journal/data', [JournalController::class, 'getData'])->name('journal.data');

        // Resource Routes
        Route::resource('account-category', AccountCategoryController::class);
        Route::resource('account-type', AccountTypeController::class);
        Route::resource('account', AccountController::class);
        Route::resource('journal', JournalController::class);
    });

    // Activity Log Routes
    Route::prefix('activity-log')->group(function () {
        Route::get('/', [ActivityLogController::class, 'index'])->name('activity-log.index');
        Route::get('/detail/{id}', [ActivityLogController::class, 'detail'])->name('activity-log.detail');
        Route::get('/export', [ActivityLogController::class, 'export'])->name('activity-log.export');
    });
});

// Driver Dashboard Routes (Token-based authentication)
Route::prefix('driver')->middleware('auth.driver')->group(function () {
    Route::get('/dashboard', [DriverDashboardController::class, 'index'])->name('driver.dashboard');
    Route::post('/update-status', [DriverDashboardController::class, 'updateStatus'])->name('driver.updateStatus');
    Route::get('/delivery-info', [DriverDashboardController::class, 'getDeliveryInfo'])->name('driver.deliveryInfo');
});

require __DIR__ . '/auth.php';
